#ifndef UBXGPSNAVSOL_H_
#define UBXGPSNAVSOL_H_

#include "mbed.h"

#define  UBX_NAV_SOL_HEADER_1          (0xB5)
#define  UBX_NAV_SOL_HEADER_2          (0x62)
#define  UBX_NAV_SOL_CLASS                (0x01)
#define  UBX_NAV_SOL_ID             (0x06)
#define  UBX_NAV_SOL_PAYLOAD_LENGTH    (52)

class UbxGpsNavSol : public UARTSerial{
  public:
    UbxGpsNavSol(PinName tx, PinName rx, int baud);
    virtual ~UbxGpsNavSol();
    
    uint8_t buffer [60];
    bool ready();
    void disableNmea();
    bool enableNAVSOL();
    bool changeFrequency();
    bool changeBaudrate();
    bool disableUnnecessaryChannels();
    bool disableGNSS();
    bool restoreDefaults();
    void baud(int baud);
    bool saveConfiguration();
    // void setLength(unsigned char length);
    // Type         Name           Unit     Description (scaling)
    unsigned long   iTOW;       // ms       GPS time of week of the navigation epoch. See the description of iTOW for
                                //          details
    long            fTOW;       // ns       Fractional part of iTOW (range: +/-500000). The precise GPS time of week in
                                //          seconds is: (iTOW * 1e-3) + (fTOW * 1e-9)
    short           week;       // weeks    GPS week number of the navigation epoch
    unsigned char   gpsFix;     // -        GPSfix Type, range 0..5
    char            flags;      // -        Fix Status Flags (see graphic below)
    long            ecefX;      // cm       ECEF X coordinate
    long            ecefY;      // cm       ECEF Y coordinate
    long            ecefZ;      // cm       ECEF Z coordinate
    unsigned long   pAcc;       // cm       3D Position Accuracy Estimate
    long            ecefVX;     // cm/s     ECEF X velocity
    long            ecefVY;     // cm/s     ECEF Y velocity
    long            ecefVZ;     // cm/s     ECEF Z velocity
    unsigned long   sAcc;       // cm/s     Speed Accuracy Estimate
    unsigned short  pDOP;       // -        Position DOP (0.01)
    unsigned char   reserved1;  // -        Reserved
    unsigned char   numSV;      // -        Number of satellites used in Nav Solution
    unsigned long   reserved2;  // -        Reserved

  private:
    bool calculateChecksum(unsigned char *data);
    // Class properties
    unsigned char offsetClassProperties;
    unsigned char offsetHeaders;
    unsigned char size;
    unsigned char carriagePosition;
    unsigned char checksum[2];

    // Headers (common).
    unsigned char headerClass;
    unsigned char headerId;
    unsigned short headerLength;
    uint16_t payload_length;
};
#endif

