#include "mbed.h"
#include "LSM9DS1.h"
 
Serial pc(USBTX, USBRX);
 
int main() {
    LSM9DS1 imu(p9, p10, 0xD6, 0x3C);
    imu.begin();
    if (!imu.begin()) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
    }
    imu.calibrate();
    while(1) {
        imu.readAccel();
        imu.readMag();
        imu.readGyro();
 
        pc.printf("gyro: %d %d %d\n\r", imu.gx, imu.gy, imu.gz);
        pc.printf("accel: %d %d %d\n\r", imu.ax, imu.ay, imu.az);
        pc.printf("mag: %d %d %d\n\n\r", imu.mx, imu.my, imu.mz);
        wait(1);
    }
}