#include "mbed.h"
#include "omni_three.h"
#include "ikarashiMDC.h"

Serial pc(USBTX, USBRX, 115200);
Serial serial(PC_6,PC_7);
DigitalOut serialcontrol(D2);
DigitalOut stop(PB_12,PB_2);
Timer x,y,rad;
Omni omni(PI * 1/6, PI * 5/6, PI * 3/2);   //オムニホイールの単位円上の位置を入力

ikarashiMDC ikarashi[] {
    ikarashiMDC(&serialcontrol,2,0,SM,&serial),
    ikarashiMDC(&serialcontrol,2,1,SM,&serial),
    ikarashiMDC(&serialcontrol,2,2,SM,&serial),
    ikarashiMDC(&serialcontrol,2,3,SM,&serial)
};

int main()
{
    serial.baud(115200);
    ikarashi[0].braking = true;
    double acc[3]; s
    rad.start();
    while(1){
        if(rad >= (PI * 2))
        {
            rad.reset();
        }
        acc[0] = omni.vec(rad,0);  //
        acc[1] = omni.vec(rad,1);  //         角度のラジアン値とタイヤ番号を入力
        acc[2] = omni.vec(rad,2);  //
    
        ikarashi[0].setSpeed(acc[0] * 1/2);
        ikarashi[1].setSpeed(acc[1] * 1/2);
        ikarashi[2].setSpeed(acc[2] * 1/2);
        pc.printf("%f,%f,%f,%f\r\n",acc[0],acc[1],acc[2],rad.read());
    }
}