#ifndef STATES_H
#define STATES_H

#include "mbed.h"
#include "PID.h"
#include "pin_config.h"
#include "PS3.h"
#include "R1370.h"
#include "mechanism.h"

#define front 0
#define right 90
#define back 180
#define left -90


class States
{
public:
    States();
    void tellAngle();
    void tellPad();
    void move();
private:

    /*非常停止*/
    DigitalOut emStop;
    
    /*モーター系*/
    Serial serial;

    /*角度制御*/
    R1370 gyro;
    PID anglePID;
    float nowAngle;
    int idealAngle;
    float deviation;
    float turnPower;
    int state;
    
    /*昇降 機構*/
    Mechanism mechanism;

    /*コントローラ系*/
    PS3 pad;
    int stick[4],trigger[2];
    
    int b[12],b2[12],b3[12];
    float norm[2];
};
#endif
