#include "mbed.h"
#include "omniHairetu.h"
#include "ikarashiMDC.h"

Serial pc(USBTX, USBRX, 115200);
Serial serial(PC_6,PC_7);
DigitalOut serialcontrol(D2);
Timer rad;

omniHairetu omni[] {
    omniHairetu(PI*1/6),
    omniHairetu(PI*5/6),
    omniHairetu(PI*3/2)
};

ikarashiMDC ikarashi[] {
    ikarashiMDC(&serialcontrol,2,0,SM,&serial),
    ikarashiMDC(&serialcontrol,2,1,SM,&serial),
    ikarashiMDC(&serialcontrol,2,2,SM,&serial)
};

int main()
{
    double acc[3];
    bool count = 0;
    serial.baud(115200);
    ikarashi[0].braking = true;
    rad.start();
    while(1)
    {
        if(rad > PI*2)
        {
            rad.reset();
            count = !count;
        }
        
        for(int i=0; i < 3; i++)
        {
            if(count == 0)
            {
                acc[i] = omni[i].rightDrift(rad);
            }
            else if(count == 1)
            {
                acc[i] = omni[i].leftDrift(rad);
            }
            ikarashi[i].setSpeed(acc[i]);
            pc.printf("%f",acc[i]);
        }
        pc.printf("\r\n");
    }
}
