#include "omniHairetu.h"

omniHairetu::omniHairetu(double wheelRad)
{
    wheelrad = wheelRad;
}

double omniHairetu::vec(double rad)
{
    return sin(rad - wheelrad);
}

double omniHairetu::rightDrift(double radR)
{
    double turnR = sin(radR - wheelrad) / 2 - 0.5;
    if(turnR <= -1.0)
    {
        turnR = -1.0;
    } 
    return turnR;
}

double omniHairetu::leftDrift(double radL)
{
    double turnL = sin(radL - wheelrad) / 2 + 0.5;
    if(turnL >= 1.0)
    {
        turnL = 1.0;
    } 
    return turnL;
}
