#ifndef MECHANISM_H
#define MECHANISM_H

#include "mbed.h"
#include "pin_config.h"
#include "ikarashiMDC.h"
#include "omni_wheel.h"

class Mechanism
{
public:
    Mechanism(Serial* serial);
    void sendHeader();
    void getTrigger(int Trigger);
    void up();
    void down();
    void collect();
    void hookRight();
    void hookLeft();
    void loadRight();
    void loadLeft();
    void lift();
    void setBrake(int trigger);
    void move(float x,float y,float turnPower,float nowAngle,float norm);
    void stop();
    void noAct();

private:
    int trigger;
    ikarashiMDC **md;
    OmniWheel omni;
    float wheel[4];
    float brake,rad;
};

#endif