#include "haseMD.h"
#include "mbed.h"

HaseMD::HaseMD(PinName pwmPin) : pwmMD(pwmPin),
mdlpf(1.0/300,0.005)
{
    pwmMD.period(1.0/250000.0);
    threadMD.start(callback(this, &HaseMD::MDloop));
}

void HaseMD::setSpeed(double speed_)
{
    speed = speed_;
}

void HaseMD::MDloop()
{
    while(true){
        _pwmMD = mdlpf.path_value(speed);
        _pwmMD += ((_pwmMD < 0.1) - (_pwmMD > 0.9)) * 0.1;
        pwmMD = 0.5 + _pwmMD /2.0;
        ThisThread::sleep_for(1000.0/400);
//        threadMD.wait(1000.0/400);
        }
}