#include "sensorGen.h"

sensorgen::sensorgen()
:   camera(pixymosi, pixymiso, pixysclk),
    jy(jysda, jyscl),
    ir(IRpin),
    b0(PC_3),
    test(PA_9),
    team(PB_10),
    start(PB_5)
{
    ir.startAveraging(255);
    _line[0] = new Line(line1);
    _line[1] = new Line(line2);
    _line[2] = new Line(line3);
    _line[3] = new Line(line4);
    _line[4] = new Line(line5);
    _line[5] = new Line(line6);
    angleCount = 0;
    ballcount = 0;
    bluecount = 0;
    yellowcount = 0;
    jy.calibrateAll(50);
//    b[0] = 0;
//    b[1] = 0;
//    b[2] = 0;
//    b[3] = 0;
    thread.start(callback(this,&sensorgen::sensorloop));
}

void sensorgen::sensorloop()
{
    while(1)
    {
//        for(int i = 0; i < 4; i++){
//            if(((b0*10) > (2*i + 3)) && ((b0*10) < (2*i + 5))) b[i] = 1;
//            else b[i] = 0;
//            if(b[i] && (!b1[i])) flag[i] = 1;
//            else flag[i] = 0;
//        }
//        for(int i = 0; i < 4; i++)b1[i] = b[i];

        rawAngle = jy.getZaxisAngle();
        if(rawAngle > 180.0) rawAngle -= 360;

        angleLimit = rawAngle;
        if((angleLimit - tempAngle) > 300) angleCount -= 1;
        if((tempAngle - angleLimit) > 300) angleCount += 1;
        angle = angleLimit + angleCount * 360.0;         
        tempAngle = angleLimit;
        
        ballSig = camera.ballSignal();
        blueSig = camera.blueSignal();
        yellowSig = camera.yellowSignal();
        /*見失ったらカウントが減っていくよ*/
//        if(camera.ballSignal()) ballcount=100;
//        else ballcount--;
//        if(camera.blueSignal()) bluecount=100;
//        else bluecount--;
//        if(camera.yellowSignal()) yellowcount=100;
//        else yellowcount--;
//        if(ballcount >= 200) ballcount = 200;
//        else if(ballcount <= 0) ballcount = 0;
//        if(yellowcount >= 200) yellowcount = 200;
//        else if(yellowcount <= 0) yellowcount = 0;
//        if(bluecount >= 200) bluecount = 200;
//        else if(bluecount <= 0) bluecount = 0;
        if(camera.ballSignal())
        {
            ballTimeout.stop();
            ballTimeout.reset();
            ballTimeoutState = 0;
            ballx = CAMCENTERX - camera.ballX();
            bally = CAMCENTERY - camera.ballY();
        }
        else if(ballTimeoutState == 0)
        {
            ballTimeoutState = 1;
            ballTimeout.start();
        }
        else if(ballTimeout > 1.0)
        {
            ballx = 0;
            bally = 0;
        }
        if(camera.blueSignal())
        {
            blueTimeout.stop();
            blueTimeout.reset();
            blueTimeoutState = 0;
            bluex = CAMCENTERX - camera.blueX();
            bluey = CAMCENTERY - camera.blueY();
        }
        else if(blueTimeoutState == 0)
        {
            blueTimeoutState = 1;
            blueTimeout.start();
        }
        else if(blueTimeout > 0.5)
        {
            bluex = 0;
            bluey = 0;
        }
        if(camera.yellowSignal() )
        {
            yellowTimeout.stop();
            yellowTimeout.reset();
            yellowTimeoutState = 0;
            yellowx = CAMCENTERX - camera.yellowX();
            yellowy = CAMCENTERY - camera.yellowY();
        }
        else if(yellowTimeoutState == 0)
        {
            yellowTimeoutState = 1;
            yellowTimeout.start();
        }
        else if(yellowTimeout > 0.5)
        {
            yellowx = 0;
            yellowy = 0;
        }
        
        ballAngle = atan2(ballx,bally) * -180/PI;
        ballRange = hypot(ballx,bally);
        blueAngle = atan2(bluex,bluey) * -180/PI;
        blueRange = hypot(bluex,bluey);
        yellowAngle = atan2(yellowx,yellowy) * -180/PI;
        yellowRange = hypot(yellowx,yellowy); 
        for(int i=0; i < 6; i++) line[i] = _line[i]->judg();
        if(irVal >= 20) ballKeep = 1;
        else ballKeep = 0;
        
//        ballKeep = 0;
        if (ballKeep) {
            ballkeepcount = 50;
        } else if(ballkeepcount > 0) {
            ballkeepcount--;
        }
        irVal = ir.getDistance();
        ThisThread::sleep_for(1000/300);
    }

}