#ifndef PIN_CONFIG_H
#define PIN_CONFIG_H

#include "mbed.h"

//#define PI 3.1415926535

/*MDC*/
#define MDTX PC_6
#define MDRX PC_7
#define MDBAUD 115200
#define MDcontrol D15

/*コントローラ*/
#define padTX PC_12
#define padRX PD_2

/*R1370*/
#define GYROTX PB_6
#define GYRORX PA_10

/*非常停止*/
#define STOP PA_7

/*PID*/
const float KP = 10;         //速さ
const float KI = 5.0;        //揺れすぎたら大きく、動かな過ぎたら小さく
const float KD = 0.0000005;  //ずらしたときに戻る力　がでかすぎたら小さく、小さすぎたら大きく
const float minLimit = -1; //逆回転速度の最大値
const float maxLimit = 1;  //回転速度の最大値

/*QEI 装填*/
#define encoder1 PC_8
#define encoder2 PC_5

const int PPR = 100;
const int spinLimit = 500;

/*昇降*/
const float riseSpeed = 0.2;
const float follSpeed = -0.2;

/*機構回転速度*/
const float collectSpeed = 0.5;
const float hookSpeed = 0.2;
const float loadSpeed = 0.2;
const float liftSpeed = 0.5;

/*PC出力*/
#define PCTX USBTX
#define PCRX USBRX
#define BTTX PC_10
#define BTRX PC_11
const int PCBAUD = 115200;
const float WAITTIME = 0.05;

/*Arduino出力*/
#define LEDTX PA_0
#define LEDRX PA_1
const int LEDBAUD = 9600;
const int HEADER = 0xff;

#endif
