#include "mbed.h"//受信
#include "FEP.h"
#include "pin_config.h"
#define RX_DATA_SIZE 1

Serial pc(PC_TX,USBRX,9600);
FEP fep(FEP_TX, FEP_RX, 000);
DigitalOut EmergencyPower[2] = { DigitalOut(Em_POWER_0), DigitalOut(Em_POWER_1)};
DigitalOut led1(LED_0);

int main()
{
    uint8_t rxdata[RX_DATA_SIZE];
    fep.startReceive(RX_DATA_SIZE);
    while (true) {
        fep.getData(rxdata);
        if(fep.status) {
            led1 = !rxdata[0];
            EmergencyPower[0] = (rxdata[0] > 1) ? EmergencyPower[0] : rxdata[0];
            EmergencyPower[1] = (rxdata[0] > 1) ? EmergencyPower[1] : rxdata[0];
        } else {
            led1 = false;
            EmergencyPower[0] = false;
            EmergencyPower[1] = false;
        }
        pc.printf("%d\r\n",rxdata[0]);
    }
}