/**********************************************************************************************
 Copyright (c) 2014 DisplayModule. All rights reserved.

 Redistribution and use of this source code, part of this source code or any compiled binary
 based on this source code is permitted as long as the above copyright notice and following
 disclaimer is retained.

 DISCLAIMER:
 THIS SOFTWARE IS SUPPLIED "AS IS" WITHOUT ANY WARRANTIES AND SUPPORT. DISPLAYMODULE ASSUMES
 NO RESPONSIBILITY OR LIABILITY FOR THE USE OF THE SOFTWARE.
 ********************************************************************************************/

/******************************************************************************
 * Tested on NUCLEO-F401RE, LPCXpresso11U68, LPCXpresso824-MAX platform.
 *****************************************************************************/

#include "mbed.h"

#include "DmTftHX8353C.h"
#include "DmTftS6D0164.h"
#include "DmTftIli9325.h"
#include "DmTftIli9341.h"
#include "DmTftSsd2119.h"
#include "DmTftRa8875.h"
#include "DmTouch.h"
#include "DmTpFt6x06.h"

/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/

/* Note that there are restrictions on which platforms that can use printf
   in combinations with the DmTftLibrary. Some platforms (e.g. LPC1549 LPCXpresso)
   use the same pins for USBRX/USBTX and display control. Printing will
   cause the display to not work. Read more about this on the display's notebook
   page. */
//#define log(...) printf(__VA_ARGS__)
#define log(...)

#if 1
/* Displays without adapter */
#define DM_PIN_SPI_MOSI   p5
#define DM_PIN_SPI_MISO   p6
#define DM_PIN_SPI_SCLK   p7
#define DM_PIN_CS_TOUCH   p25
#define DM_PIN_CS_TFT     p21
#define DM_PIN_CS_SDCARD  p23
#define DM_PIN_CS_FLASH   p24
#else
/* Displays with adapter */
#define DM_PIN_SPI_MOSI   p5
#define DM_PIN_SPI_MISO   p6
#define DM_PIN_SPI_SCLK   p7
#define DM_PIN_CS_TOUCH   p25
#define DM_PIN_CS_TFT     p21
#define DM_PIN_CS_SDCARD  p23
#endif

/******************************************************************************
 * Local variables
 *****************************************************************************/

/*********  TFT DISPLAY INIT *********/
DmTftIli9341 tft(p21, p22, p5, p6, p7);  /* DmTftIli9341(PinName cs, PinName dc, PinName mosi, PinName miso, PinName clk)  DM_TFT28_105 and DM_TFT28_116*/

/*********   TOUCH PANEL INIT  *********/

DmTouch touch(DmTouch::DM_TFT28_105, p5, p6, p7);

DigitalInOut csTouch(DM_PIN_CS_TOUCH, PIN_OUTPUT, PullUp, 1);
DigitalInOut csDisplay(DM_PIN_CS_TFT, PIN_OUTPUT, PullUp, 1);
DigitalInOut csSDCard(DM_PIN_CS_SDCARD, PIN_OUTPUT, PullUp, 1);
#ifdef DM_PIN_CS_FLASH
DigitalInOut csFlash(DM_PIN_CS_FLASH, PIN_OUTPUT, PullUp, 1);
#endif

/******************************************************************************
 * Global variables 
 *****************************************************************************/

/******************************************************************************
 * Local functions
 *****************************************************************************/

Ticker Tick;

float a;
int msek;
int sek;
int min;
int stund;
bool mode;


void zaehl()
{
    if(mode==true) {
        msek++;
        if(msek==100) {
            sek++;
            msek=0;

        }

        if(sek==60) {
            min++;
            sek=0;

        }

        if(min==60) {
            stund++;
            min=0;
        }
        if(stund==24) {
            msek=0;
            sek=0;
            min=0;
            stund=0;
        }

    }

}

void reset()
{
    msek=0;
    sek=0;
    min=0;
    stund=0;
}

/******************************************************************************
 * Main
 *****************************************************************************/

int main()
{
    log("init tft \r\n");
    mode=false;
    tft.init();
    Tick.attach(&zaehl, 0.01);

    uint16_t x = 0;
    uint16_t y = 0;
    uint16_t w = tft.width();
    uint16_t h = tft.height();

    bool down=false;
//Rectangles
    tft.drawRectangle(25, 285, 74, 310,WHITE);
    tft.drawRectangle(95, 285, 144, 310,WHITE);
    tft.drawRectangle(165, 285,214, 310,WHITE);
    tft.fillRectangle(26, 286, 73, 309, GREEN);
    tft.fillRectangle(96, 286, 143, 309, RED);
//Text
    tft.drawString(84, 30, "STOPWATCH");
    tft.drawString(30, 290, "START");
    tft.drawString(104, 290, "STOP");
    tft.drawString(170, 290, "RESET");
    
    
    touch.init();
    while (1) {
        touch.readTouchData(x, y, down);
        if(down==true&&x>=25&&x<=74&&y>=285&&y<=310)
            mode=true;

        if(down==true&&x>=95&&x<=144&&y>=285&&y<=310)
            mode=false;
            
        if(down==true&&x>=165&&x<=214&&y>=285&&y<=310)
            reset();
       
        tft.drawNumber(88,70,stund,2,1);
        tft.drawString(104, 70, ":");
        tft.drawNumber(112,70,min,2,1);
        tft.drawString(128, 70, ":");
        tft.drawNumber(136,70,sek,2,1);
        tft.drawNumber(136,86,msek,2,1);

        down=false;
    }

}