#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "string.h"

uLCD_4DGL uLCD(p9, p10, p11); // serial tx, serial rx, reset pin;
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
PwmOut Red(p21);
PwmOut Green(p22);
PwmOut Blue(p23);
Serial pc(USBTX,USBRX);
//Analog Out Jack
AnalogOut DACout(p18);
//On Board Speaker
PwmOut PWMout(p26);
 
wave_player waver(&DACout,&PWMout);

// mutex to make the lcd lib thread safe
Mutex lcd_mutex;

// Thread 1
// Increments counter on screen
void thread1(void const *args)
{
    int i = 0;

    while(true) {       // thread loop
        pc.printf("Thread 1\n\r");
        lcd_mutex.lock();
        uLCD.locate(1,2);
        uLCD.printf("%2D",i);
        lcd_mutex.unlock();
        i++;
        Thread::wait(1000); // wait 1 s
    }
}

// Thread 2
// Plays tick sound
void thread2(void const *args)
{
    FILE *wave_file=fopen("/sd/mydir/sample.wav","r");
    while(true) {       // thread loop
        pc.printf("Thread 2\n\r");
        waver.play(wave_file);
        Thread::wait(1000); // wait 1s
    }
}

// Thread 3
// Flashes led between red and blue
void thread3(void const *args)
{
    bool flag = 0;
    
    while(true) {       // main is the next thread
        pc.printf("Thread 3\n\r");
        flag = !flag;
        if(flag == 0)   // make led red
        {
            Red = 1;
            Green = 0;
            Blue = 0;
        }
        else            // make led blue
        {
            Red = 0;
            Green = 0;
            Blue = 1;
        }
        Thread::wait(500);   // wait 0.5
    }
}

int main()
{
    bool flag = 0;

    Thread t1(thread1); //start thread1
    //Thread t2(thread2); //start thread2
    Thread t3(thread3); //start thread3

    // Flashes screen background between red and blue
    while(true) {       // main is the next thread
        pc.printf("Thread 4");
        lcd_mutex.lock();
        flag = !flag;
        if(flag == 0)
        {
            uLCD.filled_circle(120, 60, 10, RED);
        }
        else
        {
            uLCD.filled_circle(120, 60, 10, BLUE);
        }
        lcd_mutex.unlock();
        Thread::wait(500);   // wait 0.5
    }
}
