#include "ledSign.h"

// Sign Output Pins

BusOut address(p17, p18, p19, p20); // Address 0 to 16
BusOut colour(p15, p16);            // 0 = off, 1 = red, 2 = green, 3 = orange

DigitalOut abTop(p14);              // bank A or B switch for Top Row - 0 = A, 1 = B
DigitalOut clkTop(p13);             // clock for Top Row
DigitalOut weTop(p28);              // Write Enable for Top Row
DigitalOut aeTop(p27);              // Address Enable for Top Row
DigitalOut enbTop(p26);             // Enable for Top Row

DigitalOut abBot(p25);              // bank A or B switch for Bottom Row - 0 = A, 1 = B
DigitalOut clkBot(p24);             // clock for Bottom Row
DigitalOut weBot(p23);              // Write Enable for Bottom Row
DigitalOut aeBot(p22);              // Address Enable for Bottom Row
DigitalOut enbBot(p21);             // Enable for Bottom Row

LedSign::LedSign() {
    address = 0;
    colour = 0;
    abTop = 0;
    clkTop = 0;
    weTop = 0;
    aeTop = 0;
    enbTop = 0;
    abBot = 0;
    clkBot = 0;
    weBot = 0;
    aeBot = 0;
    enbBot = 0;
}

void LedSign::enable() {
    enbTop = 1;
    enbBot = 1;
}

void LedSign::disable() {
    enbTop = 0;
    enbBot = 0;
}

void LedSign::swapBank() {
    (abTop) ? abTop = 0 : abTop = 1;
    (abBot) ? abBot = 0 : abBot = 1;
}

void LedSign::writeRow(int * pointer, int wRow) {
    if(wRow <= 15) {
        for(int col = 0; col < 128; col++) {
            colour = *(pointer + col);
            clockTop();
        }
        
        writeTop(wRow);
    }
    if(wRow >= 16) {
        for(int col = 0; col < 128; col++) {
            colour = *(pointer + col);
            clockBot();
        }
        
        writeBot(wRow - 16);
    }
}

void LedSign::writeScreenColour(int newColour) {
    colour = newColour; //set colour to write to screen
    for (int i=0; i<128; i++) { // clock in 128 bits to turn all the LED's on
        clockIn();
    }

    for (int i=0; i<16; i++) { //actually write them for all lines
        writeTop(i);
        writeBot(i);
    }

    swapBank();

}

//********************Private Declerations********************

void LedSign::writeTop(int topAddress) {
    address = topAddress;
    aeTop = 1;
    wait_us(1);
    weTop = 1;
    wait_us(1);
    weTop = 0;
    wait_us(1);
    aeTop = 0;
    wait_us(1);
}

void LedSign::writeBot(int botAddress) {
    address = botAddress;
    aeBot = 1;
    wait_us(1);
    weBot = 1;
    wait_us(1);
    weBot = 0;
    wait_us(1);
    aeBot = 0;
    wait_us(1);
}

void LedSign::clockTop() {
    wait_us(1);
    clkTop = 1;
    wait_us(1);
    clkTop = 0;
    wait_us(1);
}

void LedSign::clockBot() {
    wait_us(1);
    clkBot = 1;
    wait_us(1);
    clkBot = 0;
    wait_us(1);
}

void LedSign::clockIn() {
    wait_us(1);
    clkTop = 1;
    clkBot = 1;
    wait_us(1);
    clkTop = 0;
    clkBot = 0;
    wait_us(1);
}