/*
txtFile.h

Header file containing outline for all methods dealing
with txt file data, editing, reading, searching etc.

*/

#ifndef TXTFILE_H
#define TXTFILE_H

#include "mbed.h"
#include "SDFileSystem.h"
#include <string>

class TxtFile {

public:
//constructor and deconstructor
    TxtFile(char fileAddr[], char *readWrite, bool doParseFile);
    ~TxtFile();

    //returns whether a file is open or not
    bool isOpen();                  //done

    //closes the file and returns true if successful
    bool closeFile();               //done
    
    //returns if the file is parsed or not
    bool isParsed();                //done
    
    //counts the number of lines and sets the line start locations
    void parseFile();               //needs testing
    
    //returns the number of lines
    int lineCount();

    //seeks to the position seekLoc
    void seekPos(int seekLoc);      //done
    
    //returns currentFilePos
    int getPos();                   //done
    
    //seeks to the start of the current line
    int seekLineStart();
    
    //seeks to the end of the current line
    int seekLineEnd();
    
    //seeks to a specific line start
    void seekLine(int line);
    
    //returns which line pointer is on
    int getLine();

    //returns the length of the current line
    int lineLength();               //done
    
    //converts a csv in a file to an array - will only read off one line
    void csvToIntArray(int line, int arrayStart, int arrayEnd, int *array);
    
    //reads a line
    void readLine(int line);
    

private:

    FILE *fp;

    bool isFileOpen;                //value representing if the file is open or not
    bool isFileParsed;              //representing if the file has been parsed or not
    
    int noLines;                    //number of lines in the file, with a -1 offset (1 line = 0, 2 lines = 1 etc)
    int fileLineStart[];            //starting seek location for every line in the file
    int fileLineLength[];           //length of each line
    int currentFilePos;             //current position in the file relative to the start
};

#endif