#include "txtFile.h"


/**
* Constructor when called opens a file
*
* @param fileAddr
*               the address of the file, either local, sd or whatever
* @param readWrite
*               whether reading or writing to the file
*/
TxtFile::TxtFile(char fileAddr[], char *readWrite, bool doParseFile) {

    isFileOpen = false;
    isFileParsed = false;
    currentFilePos = 0;

    if ((fp = fopen(fileAddr, readWrite)) == NULL) {
        isFileOpen = false;
    } else {
        isFileOpen = true;
    }
    
    if(doParseFile) {
        parseFile();
        isFileParsed = true;
    }
}

/**
* Destructor when called closes the open file
*/
TxtFile::~TxtFile() {
    closeFile();
}

/**
* Returns true if the file is open
*
* @returns isFileOpen
*/
bool TxtFile::isOpen() {
    return isFileOpen;
}

/**
* Returns true if file has been parsed
*
* @returns isFileParsed
*/
bool TxtFile::isParsed() {
    return isFileParsed;
}

/**
* Checks if the file is open, and closes it if it is
*
* @returns isClosed
*               returns true if a file was closed, false if not
*/
bool TxtFile::closeFile() {
    if (isOpen()) {
        fclose(fp);
        return true;
    } else
        return false;
}

/**
* Counts the number of lines, and sets line start positions
*/
void TxtFile::parseFile() {
    int c = 0;                                              //current character
    int cPrev = 0;                                          //previous character
    int lengthCount = 0;                                    //local length counter
    int lineCount = 0;                                      //local line counter
    int curPos = 0;                                         //current position in file

    if (!isFileParsed) {                                    //check to see if not already done
        seekPos(0);                                         //seek to beginning of file

        c = fgetc(fp);                                      //get first character
        fileLineStart[lineCount] = curPos;                  //first line ALWAYS starts at zero... so far anyway

        while (c != EOF) {                                  //while not at the end of the file
            if ((c != '\n') && (c != '\r')) {               //if not a newline or carriage return
                lengthCount++;                              //increment length counter
            }

            if (((c == '\n') && (cPrev == '\r')) || ((c == '\r') && (cPrev == '\n'))) { //if a newline (\r\n or \n\r)
                fileLineLength[lineCount] = lengthCount;    //set fileLineLength for current line to lengthCount
                lineCount++;                                //increment line counter
                lengthCount = 0;                            //reset lengthCount
                fileLineStart[lineCount] = curPos + 1;      //set file line start to next position          -   may not need the +1?
            }
            curPos++;
            cPrev = c;
            c = getc(fp);
        }

        noLines = lineCount;

        isFileParsed = true;
        seekPos(0);                                         //seek back to the beginning of the file
    }
}

/**
* Returns the number of lines in the file
*
* @returns noLines
*/
int TxtFile::lineCount() (
    return noLines;
}

/**
* Seeks to the position in the current opened file
*
* @params seekLoc
*               byte location to seek to
*/
void TxtFile::seekPos(int seekLoc) {
    fseek(fp, seekLoc, SEEK_SET);
    currentFilePos = seekLoc;
}

int TxtFile::getPos() {
    return currentFilePos;
}

int TxtFile::seekLineStart() {
    int backCount = 0;
    int c = 0;

    c = fgetc(fp);                              //get character at current position

    while ((c != '\n') && (c != '\r')) {        //check if character is a newline or carriage return
        backCount++;                            //increment backCount
        fseek(fp, -2, SEEK_CUR);                //seek back 2, 1 for the fgetc, 1 more to actually go back one
        c = fgetc(fp);                          //get a new character
    }
    currentFilePos -= backCount;
    return backCount;
}

int TxtFile::seekLineEnd() {
    int count = 0;
    int c = 0;
    
    c = fgetc(fp);                              //get character at position after the newline or carriage return

    while ((c != '\n') && (c != '\r')) {        //check if character is a newline or carriage return
        count++;                                //increment main counter
        c = fgetc(fp);                          //get a new character
    }
    currentFilePos += count;
    return count;
}

void TxtFile::seekLine(int line) {
    if(isFileParsed) {
        seekPos(fileLineStart[line - 1]);
    }
}

/**
* Returns the line length of the current line the 'seek head' is on
*
* @returns lineLength
*/
int TxtFile::lineLength() {
    int count;                              //initialise all values needed

    seekLineStart();

    count = seekLineEnd();

    return count;                               //return count, which is the number of characters in the line
}

/**
*
*/
void csvToIntArray(int line, int arrayStart, int arrayEnd, int *array) {


// int i = char a - '0' <---- really easy way to convert char to int. :D
}