#include "mbed.h"
#include "SDFileSystem.h"
#include <string>
#include <stdio.h>
#include <stdlib.h>

#include "ledSign.h"
#include "txtFile.h"

int frameLength = 4167;

SDFileSystem sd(p5, p6, p7, p8, "sd");
LedSign sign;

Timer timer;

//displaying stuff and variables needed
void displayLed(char ledFile[]);
bool ledParsed = false;
int noFrames = 0;
int curFrame = 0;
int frameTime = 0;
void writeFrame(int frame);


//int testRow[128] = {1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2};

int readRow[128];
//char buffer[300];

string rootDir[10];

void readDir();

int curFile;

void buttonCheck();

DigitalIn buttonUp(p9);
DigitalIn buttonDown(p10);

int buttonCount = 0;

//DigitalOut myled1(LED1);
//DigitalOut myled2(LED2);

int main() {
    sign.enable();
    readDir();
    
    /*for(int i = 0; i < 10 ; i++) {
    printf("%s\n", rootDir[i]);
    }*/
    
    curFile = 0;
    
    while(true) {
    //myled1 = !myled1;
    char toShow[20];
    sprintf(toShow,"/sd/%s", rootDir[curFile]);
    displayLed(toShow);
    buttonCheck();
    } 
}

void displayLed(char ledFile[]) {
    TxtFile file(ledFile, "r");
    if(file.isOpen()) {
    
        if(!ledParsed) {
            noFrames = file.totalFrames();
            curFrame = 0;
            ledParsed = true;
        }
        
        if(timer.read_ms() >= frameTime) {
        //myled2 = !myled2;
        timer.stop();
        timer.reset();
        if(curFrame == 0) {
            frameTime = file.frameTime(curFrame);
            for(int i=0;i<32;i++) {
                for(int j=0;j<128;j++) {
                    int pointing = (curFrame * frameLength) + 7 + (i * 130) + j;
                    readRow[j] = file.getChar(pointing) - '0';
                }
                sign.writeRow(readRow, i);
            }
            sign.swapBank();
            curFrame++;
            timer.start();
        } else {
            frameTime = file.frameTime(curFrame);
            for(int i=0;i<32;i++) {
                for(int j=0;j<128;j++) {
                    int pointing = (curFrame * frameLength) + 7 + (i * 130) + j;
                    readRow[j] = file.getChar(pointing) - '0';
                }
                sign.writeRow(readRow, i);
            }
            sign.swapBank();
            curFrame++;
            timer.start();
        }
        
        if(curFrame == noFrames) {
            curFrame = 0;
        }
        
        }
        
        
    }
}

void readDir() {
    DIR *d;
    struct dirent *p;

    d = opendir("/sd");
    if (d != NULL) {
        int i = 0;
        while ((p = readdir(d)) != NULL) {
            rootDir[i] = p->d_name;
            //printf(" - %s\n", p->d_name);
            i++;
        }
    } else {
        //printf("Could not open directory!\n");
    }
    closedir(d);
}

void buttonCheck() {
    if(buttonUp && (buttonCount == 0)) {
        curFile++;
        ledParsed = false;
        buttonCount = 10;
    }
    if(buttonDown && (buttonCount == 0)) {
        curFile--;
        ledParsed = false;
        buttonCount = 10;
    }
    if(curFile>9)
        curFile = 0;
    else if(curFile<0)
        curFile = 9;
    
    if(buttonCount != 0)
        buttonCount--;
}