#include "txtFile.h"

/**
* Constructor when called opens a file
*
* @param fileAddr
*               the address of the file, either local, sd or whatever
* @param readWrite
*               whether reading or writing to the file
*/
TxtFile::TxtFile(char fileAddr[], char *readWrite) {


    if ((fp = fopen(fileAddr, readWrite)) == NULL) {
        isFileOpen = false;
    } else {
        isFileOpen = true;
    }
}

/**
* Destructor when called closes the open file
*/
TxtFile::~TxtFile() {
    closeFile();
}

/**
* Returns true if the file is open
*
* @returns isFileOpen
*/
bool TxtFile::isOpen() {
    return isFileOpen;
}

/**
* Checks if the file is open, and closes it if it is
*
* @returns isClosed
*               returns true if a file was closed, false if not
*/
bool TxtFile::closeFile() {
    if (isOpen()) {
        fclose(fp);
        return true;
    } else
        return false;
}

int TxtFile::frameTime(int frame) { //a frame is 5 digits of timer, 128x32 bytes of data, with 33 line ends
    fseek(fp, (frame * 4167), SEEK_SET);
    char numberIn[5];
    for (int i=0;i<5;i++)
    {
        numberIn[i] = fgetc(fp);
    }
    return atoi(numberIn);
}

int TxtFile::totalFrames() {
    fseek(fp, 0, SEEK_END); // seek to end of file
    int size = ftell(fp);       // get current file pointer
    fseek(fp, 0, SEEK_SET); // seek back to beginning of file
    return (size + 2)/4167;
}

char TxtFile::getChar(int seek) {
    fseek(fp, seek, SEEK_SET);
    return fgetc(fp);
}