/*
ledSign.h

Header file for all LED sign processes for control

*/

#ifndef LEDSIGN_H
#define LEDSIGN_H

#include "mbed.h"

class LedSign {

public:

//Constructor - initialise all pins to 0
LedSign();

void enable();
void disable();

//Swaps the display buffers
void swapBank();

//writes a colour to the whole screen
void writeScreenColour(int newColour);

//write a row of LED's to the back buffer
void writeRow(int * pointer, int wRow);

private:

//Write the top and bottom buffer lines to memory
void writeTop(int topAddress);
void writeBot(int botAddress);

//clock data into top and bottom banks
void clockTop();
void clockBot();
void clockIn();

};


#endif