#ifndef MBED_FUTABA_SERVO_H
#define MBED_FUTABA_SERVO_H

#include "mbed.h"

class Futaba {
private:
    Serial _device;         // tx, rx
    DigitalOut _REDE; //transmitt enable or disenable

public:
    Futaba(PinName tx ,PinName rx, PinName REDE);
    void Init();
    void SetTmax(unsigned char ID, unsigned char data);
    void TorqueOn (unsigned char ID);
    void TorqueOff (unsigned char ID);
    void SetPosition (unsigned char ID, int data);
    void SetPosition_sx2 (unsigned char ID1,unsigned char ID2,int data1, int data2);
    void SetPosition_sx4 (unsigned char ID1,unsigned char ID2,unsigned char ID3,unsigned char ID4, int data1, int data2, int data3, int data4);
    void SetTslope(unsigned char ID, unsigned char CW, unsigned char CCW);//00H~FFH 0deg~255deg
    void SetMargin(unsigned char ID, unsigned char CW, unsigned char CCW);//00H~FFH 0deg~25.5deg
    void RequestReply (unsigned char ID, unsigned char address, unsigned char Lenge);
    unsigned char WaitReply (void);
    int AnalysisReply (void);
    int GetAngle(unsigned char ID);
};

#endif