#include "mbed.h"
#include "C12832.h"

C12832 lcd(p5,p7,p6,p8,p11);
InterruptIn joystickcenter(p14);
InterruptIn button (p9);
DigitalOut led(LED1);
DigitalOut flash(LED4);
Timer debounce;
int i;


void  flip()
{
    led = !led;        //toggles the led when thejoystick is press
    if (debounce.read_ms()>2000) {
        i = 1;
        debounce.reset();
    }
}

int main()
{
    debounce.start();
    joystickcenter.rise (&flip);     //attach function address to the rising edge
    button.mode(PullUp);            //with this no external pull up resistor needed.
    button.rise(&flip);            //attach the function address to the rising edge
    while(1) {                    // wait around, interrpt will interrupt this!
        flash = !flash;
        wait (1);
        if( i== 1) {
            lcd.locate(0,0);
            lcd.printf("flip function used %d", led.read());
            i =0;

        }
    }

}


