#include "switches.h"

/*
//Thread events
osEvent evt1;
osEvent evt2;

//Thread ID
osThreadId sw1functionid;
osThreadId sw2functionid;
osThreadId startid;

InterruptIn sw1(PE_12);
InterruptIn sw2(PE_14);

SwitchDebounce* sm1;
SwitchDebounce* sm2;

//Date and Time Iniziliazation
int dd=00;          //Reresents day
int mm=00;          //Reresents month
int yy=00;          //Reresents year

int hh=00;          //Represents Hour 
int minute=00;      //Represents minute
int ss=00;          //Represents Seconds

//Thread Iniziliazation
Thread t1;
Thread t2;
Thread t3;
*/

//Interrupt service routine for handling the timeout
void userswTimeOutHandler() {
    userswTimeOut.detach();            //Stop the timeout counter firing

    //Which event does this follow?
    switch (userswState) {
    case EDGE_RISEN:    
        usersw.fall(&userswFallingEdge);  //Now wait for a falling edge
        break;
    case EDGE_FALLEN:
        usersw.rise(&userswRisingEdge);   //Now wait for a rising edge
        break;
    } //end switch 
}

//Interrupt service routine for a rising edge (press)
void userswRisingEdge() {
    usersw.rise(NULL);             //Disable detecting more rising edges
    userswState = EDGE_RISEN;      //Flag state
    userswTimeOut.attach(&userswTimeOutHandler, 0.2);    //Start timeout timer
}

//Interrupt service routive for SW1 falling edge (release)
void userswFallingEdge() {
    usersw.fall(NULL);                         //Disable this interrupt    
    SDqueue.call(SDmount);
    userswState = EDGE_FALLEN;                 //Flag state
    userswTimeOut.attach(&userswTimeOutHandler, 10);    //Start timeout counter 
}