#include "serial_terminal.hpp"

#define SAMPLES_IN_MEMORY 120
 
void serialterm()
{
        serial_tout.attach(serial_toutISR,TOUT_TIME_DEF);
                
        //change these sizes
        char cmnd[30];
        char arg[30];
        float val;
        int argnum;        
    
        e_commands e_cmnd;
        e_commands e_arg;
               
        argnum = sscanf(cmdBuffer,"%s %s",cmnd,arg);
        
        if(argnum != 2)
        {
            printQueue.call(puts, "INVALID COMMAND\r");
        }
        else
        {
            argnum = sscanf(arg, "%f", &val); //returns 0 if no number present
            
            e_cmnd = stringconv(cmnd);
            e_arg = stringconv(arg);            
            
            switch (e_cmnd)
            {
                
                case (READ) :
                    if ((argnum == 0 && e_arg != ALL) || (argnum == 1 && val < 1)) 
                    {
                        printQueue.call(puts, "INVALID COMMAND\r\n");
                    }
                    else if (e_arg == ALL || val >= (BUFFERSIZE-Nspaces))
                    {
                        SDqueue.call(SDread,-1); //read all                    
                    }
                    else 
                    {
                        SDqueue.call(SDread,val);  
                    }
                    break;     
                           
                case (DELETE) : 
                    if ((argnum == 0 && e_arg != ALL) || (argnum == 1 && val < 1)) 
                    {
                        printQueue.call(puts,"INVALID COMMAND\r\n");
                    }
                    else if (e_arg == ALL || val > (BUFFERSIZE-Nspaces)) SDqueue.call(SDdelete,-1); //delete all
                    else SDqueue.call(SDdelete,val);
                    break;
                    
                case (SETDATE) : 
                    timeLock.lock();
                    seconds = time(NULL);
                    timeData = localtime(&seconds);
                    set_time(mktime(timeData));
                    sscanf(arg,"%2d%2d%4d",&(timeData->tm_mday),&(timeData->tm_mon),&(timeData->tm_year));            
                    (timeData->tm_mon) = (timeData->tm_mon)-1;
                    (timeData->tm_year) = (timeData->tm_year)-1900;
                    timeLock.unlock();
                    if (mktime(timeData) == -1)
                    {
                        printQueue.call(puts,"SETDATE FAILED\r\n");
                    }
                    else
                    {
                        timeLock.lock();
                        set_time(mktime(timeData));
                        timeLock.unlock();
                        seconds = time(NULL);

											printQueue.call(printf,"DATE UPDATED TO %s\r\n\n", ctime(&seconds));
                    }
                    break;
                    
                case (SETTIME) :
                    //Get current time and update the tm structure
                    timeLock.lock();
                    seconds = time(NULL);
                    timeData = localtime(&seconds);
                    set_time(mktime(timeData));  
                    //scan the input for hhmmss
                    sscanf(arg,"%2d%2d%2d",&(timeData->tm_hour),&(timeData->tm_min),&(timeData->tm_sec));      
                    //check if the time is valid, if not do not update time
                    timeLock.unlock();
                    if (mktime(timeData) == -1)
                    {
                        printQueue.call(puts, "SETTIME FAILED\r\n");
                    }
                    else
                    {
                        timeLock.lock();
                        set_time(mktime(timeData));
                        seconds = time(NULL);
                        timeLock.unlock();

                        printQueue.call(printf,"TIME UPDATED TO %s\r\n\n", ctime(&seconds));
                        
                    }
                    break;
                    
                case (SETT) :
                    //Set the sampling rate
                    if (e_arg == ALL || val < 0.1 || val > 60) 
                    {
                        printQueue.call(puts, "OUT OF RANGE\r\n");
                    }
                    else 
                    {
                        sample_rate = val;
                        if(sampling)
                        {
                            sample.attach(&sampleISR, sample_rate);   
                        } 

                        printQueue.call(printf, "SAMPLE RATE SET TO %5.2f\r\n\n", sample_rate);
                    }
                    break;
                    
                case (STATE) :
                    if (e_arg == ON)
                    {
                        sample.attach(&sampleISR, sample_rate);
                        sampling = true;
                        printQueue.call(puts,"SAMPLING ENABLED\r\n");
                    }
                    else if (e_arg == OFF)
                    {
                        sample.detach();
                        sampling = false;
                        printQueue.call(puts,"SAMPLING DISABLED\r\n"); 
                    }
                    else
                    {
                        printQueue.call(puts,"INVALID COMMAND\r\n");
                    }
                    break;
                    
                case (LOGGING) :
                   if (e_arg == ON)
                    {
												yellowLED = 1;
                        logging = true;
                        printQueue.call(puts,"LOGGING ENABLED\r\n");
                    }
                    else if (e_arg == OFF)
                    {
												yellowLED = 0;
                        logging = false;
                        printQueue.call(puts,"LOGGING DISABLED\r\n");
                    }
                    else
                    {
                        printQueue.call(puts,"INVALID COMMAND\r\n");
                    }
                    break;
                    
                default :
                    printQueue.call(puts,"INVALID COMMAND\r\n");
                    break;            
            }    
        }
        serial_tout.detach();
        memset(cmdBuffer,0,sizeof cmdBuffer);
}

void serial_toutISR(void)
{
    threadstates |= SERIAL;   
}

void serialISR()
{
    pc->attach(NULL, Serial::RxIrq);
    serialqueue.call(serialData);
}

void serialData()
{    
    static int i = 0;
    
    if (pc->readable())
    {
        cmdBuffer[i] = pc->getc();
        if (i != 29)
        {
            
            if (cmdBuffer[i] == '\b')
            {
                i = (i ? i-1 : 0);  
            }
            else if (cmdBuffer[i] == '\r')
            {
                cmdBuffer[i+1]==NULL;
                serialqueue.call(serialterm);
                i = 0;                                
            }
            else i++;
        }
        else
        {
            serialqueue.call(serialterm);
            i = 0;
        }
    }
    pc->attach(serialISR, Serial::RxIrq);
}

e_commands stringconv(string in)
{
    if (in == "READ") return READ;
    if (in == "DELETE") return DELETE;
    if (in == "SETDATE") return SETDATE;
    if (in == "SETTIME") return SETTIME;
    if (in == "SETT") return SETT;
    if (in == "STATE") return STATE;
    if (in == "LOGGING") return LOGGING;
    if (in == "ALL") return ALL;
    if (in == "ON") return ON;
    if (in == "OFF") return OFF;
    else return UNKNOWN;
}