#include "serial_terminal.hpp"
#include "serial_terminal.hpp"
#include "sample_hardware.hpp"
#include "mbed_events.h"
#include "SDCard.hpp"
#include "mbed.h"

#define SAMPLES_IN_MEMORY 120
 
void serialterm()
{
        serial_tout.attach(serial_toutISR,TOUT_TIME_DEF);
        
        //static time_t seconds;
        
        //change these sizes
        char cmnd[30];
        char arg[30];
        float val;
        int argnum;        
    
        e_commands e_cmnd;
        e_commands e_arg;
               
        argnum = sscanf(cmdBuffer,"%s %s",cmnd,arg);
        
        if(argnum != 2)
        {
            /*
            printlock.lock();
            pc->printf("INVALID COMMAND\r\n");   
            printlock.unlock();
            */
            printQueue.call(puts, "INVALID COMMAND\r");
        }
        else
        {
            argnum = sscanf(arg, "%f", &val); //returns 0 if no number present
            
            e_cmnd = stringconv(cmnd);
            e_arg = stringconv(arg);
            
            /*
            if(logging)
            {
                printlock.lock();
                pc->printf("Command %s recieved with argument of %s, containing %d readable numbers\r\n\n",cmnd,arg,argnum);
                printlock.unlock();   
                printQueue.call(printf,"Command %s recieved with argument of %s, containing %d readable numbers\r\n\n",cmnd,arg,argnum);
            }
            */
            
            switch (e_cmnd)
            {
                
                case (READ) :
                    if ((argnum == 0 && e_arg != ALL) || (argnum == 1 && val < 1)) 
                    {
                        /*
                        printlock.lock(); 
                        pc->printf("INVALID COMMAND\n\n\r"); 
                        printlock.unlock(); 
                        */
                        printQueue.call(puts, "INVALID COMMAND\r\n");
                        //break;
                    }
                    else if (e_arg == ALL || val >= (BUFFERSIZE-Nspaces))
                    {
                        SDqueue.call(SDread,-1); //read all                    
                    }
                    else 
                    {
                        SDqueue.call(SDread,val);  
                    }
                    break;     
                           
                case (DELETE) : 
                    if ((argnum == 0 && e_arg != ALL) || (argnum == 1 && val < 1)) 
                    {
                        /*
                        printlock.lock(); 
                        pc->printf("INVALID COMMAND\n\n\r"); 
                        printlock.unlock(); 
                        */
                        printQueue.call(puts,"INVALID COMMAND\r\n");
                        //break;
                    }
                    else if (e_arg == ALL || val > (BUFFERSIZE-Nspaces)) SDqueue.call(SDdelete,-1); //delete all
                    else SDqueue.call(SDdelete,val);
                    break;
                    
                case (SETDATE) : 
                    timeLock.lock();
                    seconds = time(NULL);
                    timeData = localtime(&seconds);
                    //localtime_r(&seconds, timeData);
                    set_time(mktime(timeData));
                    sscanf(arg,"%2d%2d%4d",&(timeData->tm_mday),&(timeData->tm_mon),&(timeData->tm_year));            
                    (timeData->tm_mon) = (timeData->tm_mon)-1;
                    (timeData->tm_year) = (timeData->tm_year)-1900;
                    timeLock.unlock();
                    if (mktime(timeData) == -1)
                    {
                        /*
                        printlock.lock();
                        pc->printf("SETDATE failed\n\n\r");
                        printlock.unlock();   
                        */
                        printQueue.call(puts,"SETDATE FAILED\r\n");
                    }
                    else
                    {
                        timeLock.lock();
                        set_time(mktime(timeData));
                        timeLock.unlock();
                        seconds = time(NULL);
                        /*
                        printlock.lock();
                        pc->printf("Date updated to %s\n\n\r", ctime(&seconds));
                        printlock.unlock();
                        */
                        printQueue.call(printf,"DATE UPDATED TO %s\r\n\n", ctime(&seconds));
                    }
                    break;
                    
                case (SETTIME) :
                    //Get current time and update the tm structure
                    timeLock.lock();
                    seconds = time(NULL);
                    timeData = localtime(&seconds);
                    set_time(mktime(timeData));  
                    //scan the input for hhmmss
                    sscanf(arg,"%2d%2d%2d",&(timeData->tm_hour),&(timeData->tm_min),&(timeData->tm_sec));      
                    //check if the time is valid, if not do not update time
                    timeLock.unlock();
                    if (mktime(timeData) == -1)
                    {
                        /*
                        printlock.lock();
                        pc->printf("SETTIME FAILED\n\n\r");
                        printlock.unlock();   
                        */
                        printQueue.call(puts, "SETTIME FAILED\r\n");
                    }
                    else
                    {
                        timeLock.lock();
                        set_time(mktime(timeData));
                        seconds = time(NULL);
                        timeLock.unlock();
                        /*
                        printlock.lock();
                        pc->printf("TIME UPDATED TO %s\n\n\r", ctime(&seconds));
                        printlock.unlock();
                        */
                        printQueue.call(printf,"TIME UPDATED TO %s\r\n\n", ctime(&seconds));
                        
                    }
                    break;
                    
                case (SETT) :
                    //Set the sampling rate
                    if (e_arg == ALL || val < 0.1 || val > 60) 
                    {
                        /*
                        printlock.lock(); 
                        pc->printf("OUT OF RANGE\n\n\r"); 
                        printlock.unlock();
                        */
                        printQueue.call(puts, "OUT OF RANGE\r\n");
                        //break;
                    }
                    else 
                    {
                        sample_rate = val;
                        if(sampling)
                        {
                            sample.attach(&sampleISR, sample_rate);   
                        } 
                        /*                   
                        printlock.lock(); 
                        pc->printf("Sample rate set to %5.2f\n\n\r", sample_rate); 
                        printlock.unlock();}                
                        */
                        printQueue.call(printf, "SAMPLE RATE SET TO %5.2f\r\n\n", sample_rate);
                        //break;
                    }
                    break;
                    
                case (STATE) :
                    if (e_arg == ON)
                    {
                        sample.attach(&sampleISR, sample_rate);
                        sampling = true;
                        /*
                        printlock.lock();
                        pc->printf("Sampling ON\n\n\r");
                        printlock.unlock();
                        */
                        printQueue.call(puts,"SAMPLING ENABLED\r\n");
                        //break;
                    }
                    else if (e_arg == OFF)
                    {
                        //sample.attach(NULL, sample_rate);
                        sample.detach();
                        sampling = false;
                        /*
                        printlock.lock();
                        pc->printf("Sampling OFF\n\n\r");
                        printlock.unlock();
                        */
                        printQueue.call(puts,"SAMPLING DISABLED\r\n");
                        //break; 
                    }
                    else
                    {
                        /*
                        printlock.lock();
                        pc->printf("Invalid command\n\n\r"); 
                        printlock.unlock();
                        */
                        printQueue.call(puts,"INVALID COMMAND\r\n");
                        //break;
                    }
                    break;
                    
                case (LOGGING) :
                   if (e_arg == ON)
                    {
                        logging = true;
                        /*
                        printlock.lock();
                        pc->printf("LOGGING ON\n\n\r");
                        printlock.unlock();
                        */
                        printQueue.call(puts,"LOGGING ENABLED\r\n");
                        //break;
                    }
                    else if (e_arg == OFF)
                    {
                        logging = false;
                        /*
                        printlock.lock();
                        pc->printf("LOGGING OFF\n\n\r");
                        printlock.unlock();
                        */
                        printQueue.call(puts,"LOGGING DISABLED\r\n");
                        //break; 
                    }
                    else
                    {
                        /*
                        printlock.lock();
                        pc->printf("INVALID COMMAND\n\n\r"); 
                        printlock.unlock();
                        */
                        printQueue.call(puts,"INVALID COMMAND\r\n");
                        //break;
                    }
                    break;
                    
                default :
                    /*
                    printlock.lock();
                    pc->printf("INVALID COMMAND\n\n\r");
                    printlock.unlock();
                    */
                    printQueue.call(puts,"INVALID COMMAND\r\n");
                    break;            
            }    
        }
        serial_tout.detach();
        memset(cmdBuffer,0,sizeof cmdBuffer);
}

e_commands stringconv(string in)
{
    if (in == "READ") return READ;
    if (in == "DELETE") return DELETE;
    if (in == "SETDATE") return SETDATE;
    if (in == "SETTIME") return SETTIME;
    if (in == "SETT") return SETT;
    if (in == "STATE") return STATE;
    if (in == "LOGGING") return LOGGING;
    if (in == "ALL") return ALL;
    if (in == "ON") return ON;
    if (in == "OFF") return OFF;
    else return UNKNOWN;
}