#ifndef __serial_terminal__
#define __serial_terminal__

#include "mbed.h"
#include "sample_hardware.hpp"
#include "SDCard.hpp"
#include "mbed_events.h"
#include <iostream>
#include <string>


extern struct tm* timeData;
extern time_t seconds;
extern char cmdBuffer[256];
extern float sample_rate;
extern Ticker sample;
extern void sampleISR(void);
extern void serialISR(void);
extern bool logging;
extern bool sampling;
extern Timeout serial_tout;
extern void serial_toutISR(void);
extern EventQueue printQueue;

typedef enum 
{
    READ,DELETE,SETDATE,SETTIME,SETT,STATE,LOGGING,ALL,ON,OFF,UNKNOWN
} e_commands;

void serialterm(void);
e_commands stringconv(string in);

#endif