#ifndef __sample_hardware__
#define __sample_hardware__

#include "main.h"
#include "SDCard.hpp"

//#define BME
#ifdef BME
#include "BME280.h"
#else
#include "BMP280.h"
#endif
#include "TextLCD.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include <string>

class sensorData
{
    private:
        double temperature;
        double pressure;
        float  lightlevel;
        string time_str;
    public:
        sensorData(void);
        void updatetemp(double t);        
        void updatepress(double p);        
        void updatelight(float l);        
        void updateTime();        
        double gettemp(void);        
        double getpress(void);        
        float getlight(void);        
        string getTime(void);
};

extern sensorData buffer[BUFFERSIZE];

enum ELEC350_ERROR_CODE {OK, FATAL};

extern RawSerial* pc;
extern DigitalOut onBoardLED;
extern DigitalOut redLED;
extern DigitalOut yellowLED;
extern DigitalOut greenLED;

extern DigitalIn  onBoardSwitch;
extern DigitalIn  SW1;
extern DigitalIn  SW2;
extern AnalogIn adcIn;

extern FATFileSystem* fs;

#ifdef BME
extern BME280 sensor;
#else
extern BMP280 sensor;
#endif

extern TextLCD lcd;
extern SDBlockDevice sd;

extern void post();
extern void errorCode(ELEC350_ERROR_CODE err);
extern void sampleProducer();
extern void sampleConsumer();
extern void sampleISR();
extern void producer_toutISR(void);
extern void consumer_toutISR(void);

#endif