#ifndef __sample_hardware__
#define __sample_hardware__

//#define BME
#ifdef BME
#include "BME280.h"
#else
#include "BMP280.h"
#endif
#include "TextLCD.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include <string>

#define BUFFERSIZE 120

//TEST FOR SD CARD
#define SIGNAL_SD 3

#define TOUT_TIME_DEF 2
#define TOUT_TIME_SDREAD 16
#define TOUT_TIME_SDMOUNT 8



extern Mutex timeLock;

class sensorData
{
    private:
        double temperature;
        double pressure;
        float  lightlevel;
        //struct tm* timeData;
        string time_str;
    public:
        sensorData(void)
        {
            this->temperature = 0;
            this->pressure = 0;
            this->lightlevel = 0;
            this->time_str = "";            
        }
        
        void updatetemp(double t)
        {
            this->temperature = t;  
        };
        
        void updatepress(double p)
        {
            this->pressure = p;
        };
        
        void updatelight(float l)
        {
            this->lightlevel = l;
        };
        
        void updateTime()
        {
            string t;
            time_t seconds; 
            timeLock.lock();
            seconds = time(NULL);            
            t = ctime(&seconds);
            timeLock.unlock();
            t = t.substr(0,t.length()-1);
            this->time_str = t; 
            
        }
        
        double gettemp(void)
        {
           return this->temperature; 
        };
        
        double getpress(void)
        {
          return this->pressure;  
        };
        
        float getlight(void)
        {
          return this->lightlevel;  
        };
        
        string getTime(void)
        {
            return this->time_str;
        }
};

enum ELEC350_ERROR_CODE {OK, FATAL};


extern RawSerial* pc;
extern DigitalOut onBoardLED;
extern DigitalOut redLED;
extern DigitalOut yellowLED;
extern DigitalOut greenLED;

extern DigitalIn  onBoardSwitch;
extern DigitalIn  SW1;
extern DigitalIn  SW2;
//extern Serial pc;
extern AnalogIn adcIn;

#ifdef BME
extern BME280 sensor;
#else
extern BMP280 sensor;
#endif

extern TextLCD lcd;
extern SDBlockDevice sd;

//TEST
extern EventQueue LCDqueue;
extern void LCD_text(string text);


extern void post();
extern void errorCode(ELEC350_ERROR_CODE err);

#endif