#include "mbed.h"
#include <stm32f4xx.h>
#include "rtos.h"
#include "events/mbed_events.h"
#include "main.h"
#include "sample_hardware.hpp"
#include "SDCard.hpp"
#include "Networking.hpp"
#include "serial_terminal.hpp"
#include "LCDdisplay.hpp"
#include "PLL_Config.h"
#include "Watchdog.h"
#include "switches.h"

//Global variables
unsigned int newestIndex = BUFFERSIZE-1;    //First time it is incremented, it will be 0
unsigned int oldestIndex = BUFFERSIZE-1;
FILE* fp;
int userswState = EDGE_FALLEN;
InterruptIn   usersw(USER_BUTTON);
int32_t Nspaces = BUFFERSIZE;
int32_t Nsamples;
char threadstates = 0;
time_t seconds;

//Shared mutable variables
bool sd_init;
bool logging = false;
bool sampling = false;
float sample_rate = 15;
struct tm* timeData;
char cmdBuffer[30];
//sensorData buffer[BUFFERSIZE];
RawSerial* pc;

//Thread synchronisation primatives
Semaphore spaceAvailable(BUFFERSIZE);
Semaphore samplesInBuffer(0, BUFFERSIZE);

Mutex bufferLock;
Mutex timeLock;

//Queues
EventQueue SDqueue(1024*EVENTS_EVENT_SIZE);
EventQueue printQueue(256*EVENTS_EVENT_SIZE);
EventQueue LCDqueue(32*EVENTS_EVENT_SIZE);
EventQueue serialqueue(32*EVENTS_EVENT_SIZE);

//Threads
Thread producer_thread(osPriorityHigh);
Thread watchdog_thread(osPriorityHigh);
Thread serial_thread(osPriorityAboveNormal);
Thread consumer_thread;
Thread SDqueue_thread;
Thread LCDqueue_thread;
Thread network_thread;
Thread printf_thread;

//Timers
Ticker sample;

Timeout userswTimeOut;
Timeout producer_tout;
Timeout consumer_tout;
Timeout serial_tout;
Timeout SD_tout;
Timeout LCD_tout;
Timeout network_tout;


int main() {   
    PLL_Config();
    timeData = new tm;
    pc = new RawSerial(USBTX, USBRX, 115200);
    
    //Initialisations
    SDcard();   
    
    //Power on self test
    post();
       
    //Start threads
    SDqueue_thread.start(callback(&SDqueue, &EventQueue::dispatch_forever));
    LCDqueue_thread.start(callback(&LCDqueue, &EventQueue::dispatch_forever));
    serial_thread.start(callback(&serialqueue, &EventQueue::dispatch_forever));
    network_thread.start(network);
    producer_thread.start(sampleProducer);
    consumer_thread.start(sampleConsumer);
    watchdog_thread.start(watchdog);
		printf_thread.start(callback(&printQueue, &EventQueue::dispatch_forever));	

    LCDqueue.call_every(5000, LCD_display);    
   
    //Attach ISRs
    //sample.attach(&sampleISR, sample_rate);  //Allow sampling to start  
    pc->attach(serialISR, Serial::RxIrq);
    
    usersw.rise(&userswRisingEdge);    
    
    while(true) 
		{
			/*Main thread actions here*/			
    }
}