#ifndef __MAIN_H__
#define __MAIN_H__

#include "mbed.h"
#include <stm32f4xx.h>

#define BUFFERSIZE 120

#define EDGE_FALLEN 0
#define EDGE_RISEN 1

//Signals
#define TAKE_SAMPLE 1
#define STORE_DATA 2
#define SIGNAL_SD 3

#define TOUT_TIME_DEF 2
#define TOUT_TIME_SDREAD 5
#define TOUT_TIME_SDMOUNT 5


//Function prototypes
extern void userswTimeOutHandler(void);
extern void userswRisingEdge(void);
extern void userswFallingEdge(void);

//Global variables
extern unsigned int newestIndex;
extern unsigned int oldestIndex;
extern FILE* fp;

extern int userswState;
extern InterruptIn usersw;
extern int32_t Nspaces;
extern int32_t Nsamples;
extern char threadstates;
extern time_t seconds;

//Shared mutable variables
extern bool sd_init;
extern bool logging;
extern bool sampling;
extern float sample_rate;
extern struct tm* timeData;
extern char cmdBuffer[30];
extern RawSerial* pc;

//Thread synchronisation primatives
extern Semaphore spaceAvailable;
extern Semaphore samplesInBuffer;

extern Mutex bufferLock;
extern Mutex timeLock;

//Queues
extern EventQueue SDqueue;
extern EventQueue printQueue;
extern EventQueue LCDqueue;
extern EventQueue serialqueue;

//Threads
extern Thread producer_thread;
extern Thread watchdog_thread;
extern Thread serial_thread;
extern Thread consumer_thread;
extern Thread SDqueue_thread;
extern Thread LCDqueue_thread;
extern Thread network_thread;
extern Thread printf_thread;

//Timers
extern Ticker sample;

extern Timeout userswTimeOut;
extern Timeout producer_tout;
extern Timeout consumer_tout;
extern Timeout serial_tout;
extern Timeout SD_tout;
extern Timeout LCD_tout;
extern Timeout network_tout;

#endif