#include "Watchdog.h"

void watchdog(void)
{
    while(true)
    {
        Thread::wait(WATCHDOG_TIME);
 
        if(threadstates)
        {
            producer_thread.terminate();
            consumer_thread.terminate();
            serial_thread.terminate();
            SDqueue_thread.terminate();
            LCDqueue_thread.terminate();
            network_thread.terminate();
            printf_thread.terminate();
            
            pc->printf("THREAD PSW: 0x%x\r\n\n", threadstates);
            pc->printf("PRODUCER     CONSUMER     SERIAL     SD CARD     LCD     NETWORK \r\n");
            pc->printf("%d            %d            %d          %d           %d       %d\r\n\n", threadstates&PRODUCER, (threadstates&CONSUMER)>>1, (threadstates&SERIAL)>>2, (threadstates&SD)>>3, (threadstates&LCD)>>4, (threadstates&NETWORK)>>5);
           
            
            switch (threadstates)
            {
                case (PRODUCER) : 
                    pc->printf("PRODUCER THREAD DEADLOCK\r\n\n");
                    lcd.cls();
                    lcd.printf("PRODUCER\nDEADLOCK");
                    break;
                
                case (CONSUMER) : 
                    pc->printf("CONSUMER THREAD DEADLOCK\r\n\n");
                    lcd.cls();
                    lcd.printf("CONSUMER\nDEADLOCK");
                    break;
                
                case (SERIAL) : 
                    pc->printf("SERIAL THREAD DEADLOCK\r\n\n");
                    lcd.cls();
                    lcd.printf("SERIAL\nDEADLOCK");
                    break;
                
                case (SD) : 
                    pc->printf("SD CARD THREAD DEADLOCK\r\n\n");
                    lcd.cls();
                    lcd.printf("SD CARD\nDEADLOCK");
                    break;
                
                case (LCD) : 
                    pc->printf("LCD THREAD DEADLOCK\r\n\n");
                    lcd.cls();
                    lcd.printf("LCD\nDEADLOCK");
                    break;
                
                case (NETWORK) : 
                    pc->printf("NETWORK THREAD DEADLOCK\r\n\n");
                    lcd.cls();
                    lcd.printf("NETWORK\nDEADLOCK");
                    break;
                
                default:
                    pc->printf("MULTIPLE THREAD DEADLOCK\r\n\n");
                    lcd.cls();
                    lcd.printf("DEADLOCK");
                    break;
            }
        
            for (int i = 0;i<50;i++)
            {
                redLED = 1;
                wait(0.05);
                redLED = 0;
                wait(0.05);
            }
            NVIC_SystemReset();
        }       
        else if (logging) 
        {
            printQueue.call(puts,"WATCHDOG RAN WITH NO DEADLOCKED THREADS\r\n"); 
        } 
    }
}
