#include "SDCard.hpp"

char fileDir[30];

void SDcard(void)
{
    SD_tout.attach(SD_toutISR,TOUT_TIME_DEF);
            
    //Initialise the SD card
    if (sd.init() != 0) {

        printQueue.call(puts,"WARNING:SD CARD INITIALISATION FAILED\r");
        sd_init = false;
    } 
    else
    {
        //Create a filing system for SD Card
        fs = new FATFileSystem("sd", &sd);

        printQueue.call(puts,"SD CARD INITIALISED\r\n");

        //Open to WRITE    
        timeLock.lock();
        seconds = time(NULL);
        timeData = localtime(&seconds);
        strftime(fileDir, 30, "sd/log_%d_%m_%y.csv", timeData);
        timeLock.unlock();
        fp = fopen(fileDir,"a");
        
        if (fp == NULL) 
        {
            printQueue.call(puts,"WARNING: COULD NOT OPEN FILE FOR WRITE\r\n"); 
        }
        else
        {
            printQueue.call(puts,"FILE OPEN FOR WRITING\r\n");
            sd_init = true;
        }     
        fclose(fp);
    }
    SD_tout.detach();
}

void SDread(int n)
{   
    bufferLock.lock();
    SD_tout.attach(SD_toutISR,TOUT_TIME_SDREAD);
	
    //Read n samples from the SD card   
    unsigned int i=0;
    unsigned int j = newestIndex;
    if (n==-1) {n = (BUFFERSIZE-Nspaces);} 
               
    while (i < n) 
    {   
        printQueue.call(printf,"Date/Time: %s\tTemperature: %5.2f\tPressure: %5.2f\tLight: %5.2f\n\r", buffer[j].getTime(), buffer[j].gettemp(), buffer[j].getpress(), buffer[j].getlight());        
        j = (j?j:BUFFERSIZE)-1; 
        i++;
    }        
    bufferLock.unlock();
    printQueue.call(printf,"%d records read\r\n\n", i);
    SD_tout.detach();    
}

void SDdelete(int n)
{
    bufferLock.lock();
    SD_tout.attach(SD_toutISR,TOUT_TIME_DEF);
	
    //Delete n samples from the SD card
    unsigned int i = 0;
    if (n==-1) {n = (BUFFERSIZE-Nspaces);}
    while (i < n)
    {
        spaceAvailable.release();
        i++;
    }
    bufferLock.unlock();
    Nspaces += i;   

    printQueue.call(printf,"Deleted %d records\r\n\n\n", i);
    SD_tout.detach();
}


void SDaddSample(string timedata, double temp, double pressure, float light, int buffind)
{
    if(sd_init)
    {
        timeLock.lock();
        seconds = time(NULL);
        timeData = localtime(&seconds);              
        strftime(fileDir, 20, "sd/log_%d_%m_%y.csv", timeData);
        timeLock.unlock();
        
        fp = fopen(fileDir,"a");
            
        if (fp == NULL)
        {
            printQueue.call(puts,"WARNING: FILE COULD NOT BE OPENED\r\n");
            sd_init = false;						
            samplesInBuffer.release();
						bufferLock.lock();
            oldestIndex = (oldestIndex?oldestIndex:BUFFERSIZE)-1; //Doesn't work properly - oldestindex will be increased by the conditional statement in the producer
						bufferLock.unlock();
        }
        else
        {
            fprintf(fp,"%s,%5.2f,%5.2f,%5.2f\r", timedata, temp, pressure, light);
            fclose(fp);
        }
                
        if(logging && sd_init)
        {
            printQueue.call(printf,"Log file %s updated with sample from position %d in buffer\r\nnewestIndex position %d\r\noldestIndex position %d\r\n\n", fileDir, buffind, newestIndex, oldestIndex);
        }
    }
    else 
    {
        samplesInBuffer.release();
				bufferLock.lock();
        oldestIndex = (oldestIndex?oldestIndex:BUFFERSIZE)-1; //Doesn't work properly - oldestindex will be increased by the conditional statement in the producer
				bufferLock.unlock();
    }
}

void SDmount(void)
{    
		SD_tout.attach(SD_toutISR,TOUT_TIME_DEF);
           
        if (sd_init)
        {
            fclose(fp);
            sd.deinit();
            sd_init = false;

            printQueue.call(puts,"SD CARD UNMOUNTED\r\n");
            
            LCDqueue.call(LCD_sdcardmount,"SD UNMOUNTED..", 0.05, greenLED);
              
              
        }
        else
        {
            SDcard();

            if (sd_init)
            {
                LCDqueue.call(LCD_sdcardmount,"SD MOUNTED..", 0.05, greenLED);
            }
            else
            {
                LCDqueue.call(LCD_sdcardmount,"SD FAILED..", 0.05, redLED); //pass in LED to flash RED
            }          
    
        } 
        SD_tout.detach();   
}

void SD_toutISR(void)
{
    threadstates |= SD;   
}

