#ifndef __SD_CARD__
#define __SD_CARD__

#include "mbed.h"
#include "sample_hardware.hpp"
#include "serial_terminal.hpp"
#include "mbed_events.h"

extern char fileDate[30];



extern bool sd_init;
extern time_t seconds;
extern tm* timeData;
extern EventQueue SDqueue;
extern FILE* fp;
extern FATFileSystem* fs;
extern unsigned int newestIndex;
extern unsigned int oldestIndex;
extern sensorData buffer[BUFFERSIZE];
extern Timeout SD_tout;
extern void SD_toutISR(void);

//TEST SD
extern Mutex printlock;
extern Mutex LCDlock;
extern Mutex timeLock;
extern Mutex bufferLock;

extern int32_t Nsamples;
extern int32_t Nspaces;
extern Semaphore spaceAvailable;
extern void LCD_sdcardmount(string text, float waittime);

extern Semaphore samplesInBuffer;

//TEST FOR PRINTF
extern EventQueue printfqueue;

void SDcard(void);
void SDread(int n);
void SDaddSample(string timedata, double temp, double pressure, float light, int buffind);
//void SDaddSample(void);
void SDdelete(int n);
void SDalive(void);

#endif