#include "SDCard.hpp"
#include <string>

void SDcard(void)
{
    SD_tout.attach(SD_toutISR,TOUT_TIME_DEF);
    
    //static time_t seconds; //static reqiured?
        
    //Initialise the SD card
    if (sd.init() != 0) {
        /*
        printlock.lock();
        pc->printf("WARNING:SD CARD INITIALISATION FAILED\n\r");
        printlock.unlock();
        */
        printQueue.call(puts,"WARNING:SD CARD INITIALISATION FAILED\r");
        sd_init = false;
        //lcd.cls();
        //lcd.printf("CANNOT INIT SD");        
        //errorCode(FATAL);
    } 
    else
    {
        //Create a filing system for SD Card
        fs = new FATFileSystem("sd", &sd);
        /*
        printlock.lock();
        pc->printf("\nSD CARD INITIALISED\n\r");
        printlock.unlock();
        */
        printQueue.call(puts,"\nSD CARD INITIALISED\r\n");

        //Open to WRITE    
        //char fileDate[30];
        timeLock.lock();
        seconds = time(NULL);
        timeData = localtime(&seconds);
        //set_time(mktime(timeData));
        strftime(fileDate, 30, "sd/log_%d_%m_%y.csv", timeData);
        timeLock.unlock();
        fp = fopen(fileDate,"a");
        
        if (fp == NULL) 
        {
            /*
            printlock.lock();
            pc->printf("WARNING: COULD NOT OPEN FILE FOR WRITE\n\r");
            printlock.unlock();
            */
            printQueue.call(puts,"WARNING: COULD NOT OPEN FILE FOR WRITE\r\n"); 
            //lcd.cls();
            //lcd.printf("CANNOT OPEN FILE\n\n");
            //errorCode(FATAL);
        }
        else
        {
            /*
            printlock.lock();
            pc->printf("FILE OPEN FOR WRITING\n\n\n\r");
            printlock.unlock();
            */
            printQueue.call(puts,"FILE OPEN FOR WRITING\r\n");
            sd_init = true;
        }     
        fclose(fp);
    }
    SD_tout.detach();
}

void SDread(int n)
{   
    //printlock.lock();
    bufferLock.lock();
    SD_tout.attach(SD_toutISR,TOUT_TIME_SDREAD);
    //Read n samples from the SD card   
    unsigned int i=0;
    unsigned int j = newestIndex;
    if (n==-1) {n = (BUFFERSIZE-Nspaces);} 
               
    while (i < n) //ONLY USE SPACE AVAILABLE - KEEP IN MIND LAST READ WAS BEFORE IT WAS DECREMENTED
    {   
        printQueue.call(printf,"Date/Time: %s\tTemperature: %5.2f\tPressure: %5.2f\tLight: %5.2f\n\r", buffer[j].getTime(), buffer[j].gettemp(), buffer[j].getpress(), buffer[j].getlight());        
        //pc->printf("Date/Time: %s\tTemperature: %5.2f\tPressure: %5.2f\tLight: %5.2f\n\r", buffer[j].getTime(), buffer[j].gettemp(), buffer[j].getpress(), buffer[j].getlight()); 
        j = (j?j:BUFFERSIZE)-1; 
        i++;
    }        
    bufferLock.unlock();
    printQueue.call(printf,"%d records read\r\n\n", i);
    //printf("%d records read\r\n\n", i);
    //printlock.unlock(); 
    SD_tout.detach();    
}

void SDdelete(int n)  //MUST RELEASE SPACE AVAILABLE
{
    bufferLock.lock();
    SD_tout.attach(SD_toutISR,TOUT_TIME_DEF);
    //Delete n samples from the SD card
    unsigned int i = 0;
    if (n==-1) {n = (BUFFERSIZE-Nspaces);}
    while (i < n)
    {
        spaceAvailable.release();
        i++;
    }
    bufferLock.unlock();
    Nspaces += i;   
    /* 
    printlock.lock();
    pc->printf("Deleted %d records\r\n\n\n", i);
    printlock.unlock();
    */
    printQueue.call(printf,"Deleted %d records\r\n\n\n", i);
    SD_tout.detach();
}


void SDaddSample(string timedata, double temp, double pressure, float light, int buffind)
{
    if(sd_init)
    {
        //static time_t seconds;
        //char fileDate[20];
        timeLock.lock();
        seconds = time(NULL);
        timeData = localtime(&seconds);        
        //set_time(mktime(timeData));        
        strftime(fileDate, 20, "sd/log_%d_%m_%y.csv", timeData);
        timeLock.unlock();
        
        fp = fopen(fileDate,"a");
            
        if (fp == NULL)
        {
            /*
            printlock.lock();
            pc->printf("WARNING: FILE COULD NOT BE OPENED\r\n\n");
            sd_init = false;
            printlock.unlock();  
            */
            printQueue.call(puts,"WARNING: FILE COULD NOT BE OPENED\r\n");
            sd_init = false;
            samplesInBuffer.release();
            oldestIndex = (oldestIndex?oldestIndex:BUFFERSIZE)-1; //Doesn't work properly - oldestindex will be increased by the conditional statement in the producer
        }
        else
        {
            fprintf(fp,"%s,%5.2f,%5.2f,%5.2f\r", timedata, temp, pressure, light);
            fclose(fp);
        }
                
        if(logging && sd_init)
        {
            /*
            printlock.lock();
            pc->printf("Log file %s updated with sample from position %d in buffer\r\n",fileDate,oldestIndex);
            pc->printf("newestIndex position %d\r\n",newestIndex);
            pc->printf("oldestIndex position %d\r\n\n",oldestIndex);
            printlock.unlock();  
            */
            printQueue.call(printf,"Log file %s updated with sample from position %d in buffer\r\nnewestIndex position %d\r\noldestIndex position %d\r\n\n", fileDate, buffind, newestIndex, oldestIndex);
            //printQueue.call(printf,"Log file updated with sample from position %d in buffer\r\nnewestIndex position %d\r\noldestIndex position %d\r\n\n", buffind, newestIndex, oldestIndex);
        }
    }
    else 
    {
        samplesInBuffer.release();
        oldestIndex = (oldestIndex?oldestIndex:BUFFERSIZE)-1; //Doesn't work properly - oldestindex will be increased by the conditional statement in the producer
    }
}

/*
void SDaddSample(void)
{
    
    static time_t seconds;
    char fileDate[30];
    timeLock.lock();
    seconds = time(NULL);
    timeData = localtime(&seconds);
    
    //set_time(mktime(timeData));
    
    strftime(fileDate, 30, "sd/log_%d_%m_%y.csv", timeData);
    timeLock.unlock();
    
    fp = fopen(fileDate,"a"); //issue if file already open?
    
    bufferLock.lock();
    
    if (fp == NULL)
    {
        printlock.lock();
        pc->printf("WARNING: FILE COULD NOT BE OPENED\r\n\n");
        sd_init = false;
        printlock.unlock();  
        samplesInBuffer.release();
    }
    else
    {
        //oldestIndex = (oldestIndex+1) % BUFFERSIZE;
        fprintf(fp,"%s,%5.2f,%5.2f,%5.2f\r", buffer[oldestIndex].getTime(), buffer[oldestIndex].gettemp(), buffer[oldestIndex].getpress(), buffer[oldestIndex].getlight());        
    }       
    
    if(logging)
    {
        printlock.lock();
        pc->printf("Log file %s updated with sample from position %d in buffer\r\n",fileDate,oldestIndex);
        pc->printf("newestIndex position %d\r\n",newestIndex);
        pc->printf("oldestIndex position %d\r\n\n",oldestIndex);
        printlock.unlock();  
    }   
    
    fclose(fp);   
    bufferLock.unlock(); 
}

*/

//UNUSED
/*
void SDalive(void)
{
    //Signal that the SD thread is still alive
    //puts("SD THREAD ALIVE\n");   
}
*/

void SDmount(void)
{
    //while(true)
    //{
        //Thread::signal_wait(SIGNAL_SD);
        
        SD_tout.attach(SD_toutISR,TOUT_TIME_SDMOUNT);
           
        if (sd_init)
        {
            fclose(fp);
            sd.deinit();
            sd_init = false;
            /*
            printlock.lock();
            pc->printf("SD CARD UNMOUNTED\n\r");
            printlock.unlock();
            */
            printQueue.call(puts,"SD CARD UNMOUNTED\r\n");
            
            //LCDlock.lock();
            //lcd.cls();
            //lcd.printf("SD UNMOUNTED..");
            //LCDqueue.call(LCD_text,"SD UNMOUNTED..");
            //Thread::wait(5000); //Dont like this
            
            //for(int i=0;i<20;i++)
            //{
               // greenLED = 1;
                //wait(0.5);
                //greenLED = 0;
                //wait(0.5);   
            //}           
            //LCDlock.unlock();          
            
            LCDqueue.call(LCD_sdcardmount,"SD UNMOUNTED..", 0.05);
              
              
        }
        else
        {
            SDcard();
            //LCDlock.lock();
            //lcd.cls();
            if (sd_init)
            {
                //lcd.printf("SD MOUNTED..");
                //LCDqueue.call(LCD_text,"SD MOUNTED..");
                LCDqueue.call(LCD_sdcardmount,"SD MOUNTED..", 0.05);
            }
            else
            {
                //lcd.printf("SD FAILED..");
                LCDqueue.call(LCD_sdcardmount,"SD FAILED..", 0.05); //pass in LED to flash RED
            }
            
            /*
            for(int i=0;i<20;i++)
            {
                greenLED = 1;
                wait(0.5);
                greenLED = 0;
                wait(0.5);   
            }
            */
            
            
            
            //Thread::wait(5000); //Dont like this
            //LCDlock.unlock();        
        } 
        SD_tout.detach(); 
    //}   
}

