#include "Networking.hpp"

//Network thread - responsible for listening for connectinos and responding with updated tempature values
void network()
{
    EthernetInterface eth;
    eth.set_network(IP, NETMASK, GATEWAY);
    eth.connect();

    printQueue.call(printf, "The target IP address is '%s'\n\n\n\r", eth.get_ip_address());
    
    //Now setup a web server
    TCPServer srv;           //TCP/IP Server
    TCPSocket clt_sock;      //Socket for communication
    SocketAddress clt_addr;  //Address of incoming connection
    
    /* Open the server on ethernet stack */
    srv.open(&eth);
    
    /* Bind the HTTP port (TCP 80) to the server */
    srv.bind(eth.get_ip_address(), 80);
    
    /* Can handle 5 simultaneous connections */
    srv.listen(5);
    
   while(true)
   {
        //Block and wait on an incoming connection
        srv.accept(&clt_sock, &clt_addr);
        
        network_tout.attach(network_toutISR,TOUT_TIME_DEF);
        
        if(logging)
        {
            printQueue.call(printf,"Incoming connection accepted on %s:%d\r\n", clt_addr.get_ip_address(), clt_addr.get_port()); 
        }
        
        //Uses a C++ string to make it easier to concatinate
        {
            string response;
            char temp_str[10];
            char press_str[10];
            char light_str[10];
            
            bufferLock.lock();
            double temp = buffer[newestIndex].gettemp();
            double press = buffer[newestIndex].getpress();
            float light  = buffer[newestIndex].getlight()*100;
            string time_str = buffer[newestIndex].getTime();        
            bufferLock.unlock();        
            
            //Convert to a C String
            sprintf(temp_str, "%5.2f", temp);
            sprintf(press_str, "%5.2f", press);
            sprintf(light_str, "%5.2f", light);
            
            
            //Build the C++ string response
            response = HTTP_RESPONSE;
            
            response += HTTP_MESSAGE_TIME;
            response += time_str;
            
            response += HTTP_MESSAGE_TEMP;
            response += temp_str;
            
            response += HTTP_MESSAGE_PRESSURE;
            response += press_str;
            
            response += HTTP_MESSAGE_LIGHT;
            response += light_str;
            
            response += HTTP_MESSAGE_FOOT;
            
            response += "\r\n"; 
                    
            //Send static HTML response (as a C string)
            clt_sock.send(response.c_str(), response.size());
            
            if(logging)
            {
                printQueue.call(printf, "Network thread responded with time: %s, temperature: %s, pressure:%s and light level: %s\r\n\n",time_str, temp_str, press_str, light_str);  
            } 
        }
        network_tout.detach();  
    }
}

void network_toutISR(void)
{
    threadstates |= NETWORK;   
}