#include "LCDdisplay.hpp"

void LCD_display()
{ 
    //Write new data to LCD (not fast!)
    bufferLock.lock();
    LCD_tout.attach(LCD_toutISR,TOUT_TIME_DEF);
    lcd.cls();
		lcd.printf("T:%3.1fC L:%4.1f%%\nP:%6.2fmBar",buffer[newestIndex].gettemp(), buffer[newestIndex].getlight()*100, buffer[newestIndex].getpress()); 
    bufferLock.unlock();   
    LCD_tout.detach();      

}

void LCD_text(string text)
{
    LCD_tout.attach(LCD_toutISR,TOUT_TIME_DEF);
    lcd.cls();
    lcd.printf("%s",text);         
    LCD_tout.detach();      
}

void LCD_sdcardmount(string text, float waittime, DigitalOut LED)
{
    LCD_tout.attach(LCD_toutISR,TOUT_TIME_SDMOUNT);
    lcd.cls();
    lcd.printf("%s",text);       
    
     for(int i=0;i<20;i++)
        {
            LED = 1;
            wait(waittime);
            LED = 0;
            wait(waittime);   
        }
    
    LCD_tout.detach();      
}

void LCD_toutISR(void)
{
    threadstates |= LCD;   
}