#include "mbed.h"

//Add more to test different setups
#include "filter_characteristics.h"


#define ON      1
#define OFF     0

float x[N]={0};
float yn;
Timer t;

void sampler(void);                     //Ticker routine PROTOTYPE

//MBED Class Instances follows
DigitalOut SampLED(LED1);               //Digital Output  (GREEN LED is PB_3, D13 You can use an Oscilloscope on This pin to confirm sample rate)
DigitalOut testpin(PA_10);

AnalogIn  Ain(PA_1);                    //Analog Input (Signal Input 0 to +3 Volts)
AnalogOut Aout(PA_4);                   //Analog Output (Signal Input 0 to +3 Volts) NB PA_4 because Arduin Nano Compatability
                                        //on STM32F303k8 uses I2C PA_5 to PB7

Ticker sample_timer;                    //Ticker class instance called sample_timer

PwmOut test(PWM_OUT);


int main() {
    float duty=0.1f;
    test.period_ms(1);
    test=duty;
  
    float sample_rate=(1.0/Fs)*1000000.0; //Calculate the number of uS required for a Frequency Sampling Rate
                                          //Fs held in *.h
  
    sample_timer.attach_us(&sampler,(int)sample_rate);
                                          //Ticker Instance serviced by routine at a repeat rate in microseconds
  
    while(1) {
        sleep();
    }
}

void sampler(void){                     //Ticker routine
    SampLED = ON;                       //LED Indicates start of sampling
    int i;                              //Initialise local variable i
    testpin = 1;
    x[0]=Ain;                           //Input ADC. N.B. ADC in MBED is 0.0 to 1.0 float!!!!!!
    yn=0.0;                             //output accumulation, start as zero
    
    
    for(i=0; i<N; i++) yn+=x[i]*b[i];   //generate output from filter components FIR a=0
    for(i=N-1; i!=0; i--) x[i]=x[i-1];  //shift data
    
    Aout=yn;                            //Output resultant to DAC. Again MBED uses 0.0 to 1.0 float!!!!!!
    
    testpin = 0;
    
    SampLED = OFF;                      //LED Indicates end of sampling
    }

