/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: End device commissioning parameters

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/
#ifndef __LORA_COMMISSIONING_H__
#define __LORA_COMMISSIONING_H__

/*!
 * When set to 1 the application uses the Over-the-Air activation procedure
 * When set to 0 the application uses the Personalization activation procedure
 */
#define OVER_THE_AIR_ACTIVATION                     1

/*!
 * Indicates if the end-device is to be connected to a private or public network
 */
#define LORAWAN_PUBLIC_NETWORK                      true

/*!
 * IEEE Organizationally Unique Identifier ( OUI ) (big endian)
 */
#define IEEE_OUI                                    0x11, 0x22, 0x33

/*!
 * Mote device IEEE EUI (big endian)
 */
#if OVER_THE_AIR_ACTIVATION
#define LORAWAN_DEVICE_EUI                          { 0x70, 0xb3, 0xd5, 0xb0, 0x20, 0x00, 0x00, 0x2d}
#else
#define LORAWAN_DEVICE_EUI              {0x70, 0xb3, 0xd5, 0xb0, 0x20, 0x00, 0x00, 0x3d}
#endif
/*!
 * Application IEEE EUI (big endian)
 */
#define LORAWAN_APPLICATION_EUI                     { 0x70, 0xb3, 0xd5, 0xb0, 0x20, 0x00, 0x00, 0x02 }

/*!
 * AES encryption/decryption cipher application key
 */
#if OVER_THE_AIR_ACTIVATION
#define LORAWAN_APPLICATION_KEY                     { 0x6f, 0xe7, 0x25, 0x89, 0x46, 0x88, 0x7a, 0x0e, 0x39, 0x8e, 0x57, 0x80, 0x28, 0x48, 0x37, 0x9f }
#else
#define LORAWAN_APPLICATION_KEY             {0x2b, 0x56, 0x86, 0x4d, 0xf8, 0x57, 0x07, 0xff, 0xe6, 0x2e, 0x39, 0xa4, 0xd9, 0x3a, 0x44, 0xb1}
#endif

/*!
 * Current network ID
 */
#define LORAWAN_NETWORK_ID                          ( uint32_t )0

/*!
 * Device address on the network (big endian)
 */
#if OVER_THE_AIR_ACTIVATION
#define LORAWAN_DEVICE_ADDRESS                      ( uint32_t )0x12345678
#else
#define LORAWAN_DEVICE_ADDRESS              (uint32_t)0x0558ef68
#endif

/*!
 * AES encryption/decryption cipher network session key
 */
#define LORAWAN_NWKSKEY                             { 0xcc, 0xc7, 0x25, 0x89, 0x46, 0x88, 0x7a, 0x0e, 0x39, 0x8e, 0x57, 0x80, 0x28, 0x48, 0x3d, 0xdd }

/*!
 * AES encryption/decryption cipher application session key
 */
#define LORAWAN_APPSKEY                             { 0xaa, 0xa7, 0x25, 0x89, 0x46, 0x88, 0x7a, 0x0e, 0x39, 0x8e, 0x57, 0x80, 0x28, 0x48, 0x3b, 0xbb }

#endif // __LORA_COMMISSIONING_H__
