// Version 10 27.07.2014
// die Ausgabe auf das Format #nr val umgestellt

#include "mbed.h"
#include "ConfigFile.h"
#include "SDFileSystem.h"
#include "DS2482.h"
#include "timer0.h"
#include "Buffer.h"
#include "monitor.h"

#define CR 13

SDFileSystem sd(PTD2, PTD3, PTC5, PTD0, "sd");  // The pinout (MOSI, MISO, SCLK, CS)
timer0 down_timer;                              // Zeitsteuerung
Serial pc(USBTX, USBRX);                        // tx, rx
Buffer <char> buf;                              // Ringbuffer für ankommende Zeichen
PwmOut heizung(PTA13);

//        sda, scl, adr
DS2482 ow(PTE0,PTE1,0x30);

DigitalOut r(LED_RED);
DigitalOut g(LED_GREEN);
DigitalOut b(LED_BLUE);

DigitalOut led1(LED1);
//DigitalOut LED2(PTA2);
DigitalOut LED5(PTA5);
DigitalOut LED_4(PTA12);

// Schalter 4051
DigitalOut DC_A(PTE2);
DigitalOut DC_B(PTE3);
DigitalOut DC_C(PTE4);
DigitalOut DC_EN(PTE5);

// PT1000 Karte 1
AnalogIn an1(PTC0);
AnalogIn an2(PTB1);
AnalogIn an3(PTB2);
AnalogIn an4(PTB3);
AnalogIn an5(PTC2);
AnalogIn an6(PTD5);

// 0 bis 5V 
AnalogIn an13(PTD6);

// Analog pins
/*
1   PTE20, ADC0_SE0,  0}, k2.2
2   PTE22, ADC0_SE3,  0}, k2.3
3   PTE21, ADC0_SE4a, 0},
4   PTE29, ADC0_SE4b, 0}, k2,4
5   PTE30, ADC0_SE23, 0}, k2.5
6   PTE23, ADC0_SE7a, 0},
7   PTB0,  ADC0_SE8,  0}, k2.1
8   PTB1,  ADC0_SE9,  0}, k1.2
9   PTB2,  ADC0_SE12, 0}, k1.3
10  PTB3,  ADC0_SE13, 0}, k1.4
11  PTC0,  ADC0_SE14, 0}, k1.1
12  PTC1,  ADC0_SE15, 0}, k2.6
13  PTC2,  ADC0_SE11, 0}, k1.5
14  PTD1,  ADC0_SE5b, 0},
15  PTD5,  ADC0_SE6b, 0}, k1.6
16  PTD6,  ADC0_SE7b, 0}, k3.1
*/

float temp1, temp_mw;
uint16_t temp_word;
uint8_t n, y, status, ds1820_status;



float temp_float, temp_diff, temp_alt, temp_neu;

ConfigFile cfg;
char value[BUFSIZ];

//------------------------------------------------------------------------------
// Werte die auch über das config file gesetzt werden können
float offset = 0.0;

//------------------------------------------------------------------------------
// Interruptroutine wird bei jedem ankommenden Zeichen aufgerufen
void rx_handler(void)
{
    // Note: you need to actually read from the serial to clear the RX interrupt
    
    char ch;
    
    while (pc.readable()) 
    {   
      ch = pc.getc();
      buf.put(ch);
    }
}

//------------------------------------------------------------------------------
// lesen der PT1000 AD-Werte
//
// Um Störungen zu reduzieren werden 16 Werte gelesen und daraus wird der
// Mittelwert berechnet. Eine Messung dauert ca. 30µs. Somit wird für eine Messung
// ca. eine Zeit von 0,5ms benötigt.
//
int read_mw(uint8_t pos)
{
    uint8_t n;
    
    int val = 0;
    int mw = 0;
    
    LED_4 = 0;
    
    // 16 Messungen für eine bessere Mittelung durchführen
    
    for (n = 0; n < 16; n++)
    {
         switch (pos)
         {      
            // PT1000 Karte 1
            case 0:  val = an1.read_u16(); break;
            case 1:  val = an2.read_u16(); break;
            case 2:  val = an3.read_u16(); break;
            case 3:  val = an4.read_u16(); break;
            case 4:  val = an5.read_u16(); break;
            case 5:  val = an6.read_u16(); break;         
         }
         mw += val;
    } // end for
    
    // Temperatur berechnen
    // Wert durch 16 teilen
    
    mw = mw >> 4;
    
    LED_4 = 1;
    
    return mw;
}

//------------------------------------------------------------------------------
//

int main() 
{
    
    heizung.period(0.020);          //  requires a 20ms period
    heizung.pulsewidth(0.005);
    temp_alt = 0.0;
    
    
    //------------------------------------------------------------------------------
    // RS232 Schnittstellt welche auf den CMSIS-DAP (USB Port) weitergeleitet wird
    //
    pc.baud(115200);
    pc.attach(&rx_handler, Serial::RxIrq);
    pc.printf("\n V08 was compiled on %s  %s \n", __DATE__,__TIME__);

    mon_init();
    
    //------------------------------------------------------------------------------
    // Timer für die Zeitsteuerung
    //
    down_timer.SetCountdownTimer(0,1,50);  // Timer für die LED
    down_timer.SetCountdownTimer(1,1,500); // Timer für den one wire bus
    down_timer.SetCountdownTimer(2,1,1000);// Timer für die Ausgabe der Daten
    
    r = g = b = 1;                          // RGB LED ausschalten
    
    //--------------------------------------------------------------------
    // Variablen von der SD Karte initialisieren
    
    cfg.read("/sd/input.cfg");
              
    if (cfg.getValue("offset", &value[0], sizeof(value))) 
    {
        offset = atof(value);
        pc.printf("\noffset = %f", offset); 
    }
    
    //--------------------------------------------------------------------
    // one wire bus 

    /*
    // pc.printf("\n ++++ on wire search ++++\n");
    wait (0.1);
    ow.DS18XX_Read_Address();
    
    n = ow.ow.devices;
    
    // Anzahl der ow Bausteine ermitteln
    y = 0;
    for (n = 0; n < OW_MAX_DEVICES; n++)
    {           
       if ((ow.ow.device_table[n].status & 0x0f) == 1) y++;
    } // end for(...
    
    // pc.printf("\n   %d devices FOUND  \n",y);

    // ow 64 bit Adressen ausgeben
    for (n = 0; n < OW_MAX_DEVICES; n++)
    {           
        if ((ow.ow.device_table[n].status & 0x0f) == 1)
        {   
            //pc.printf("\n   device #%2d  ",n); 
            //pc.printf(": adr: %2d:  ",ow.ow.device_table[n].adr );
            for (y = 0; y < 8; y++)
            {
            //    pc.printf(" %02x",ow.ow.device_table[n].rom[y]);
            }
        }

    } // end for(...

    //pc.printf("\n");

    //--------------------------------------------------------------------
    // Anfangswert bestimmen
    
    temp_mw = read_mw(0);
    
    //pc.printf("\nPT1000; DS18B20");
    status = 0;
    ds1820_status = 0;
    
    */
    
    //--------------------------------------------------------------------
    // Schleife fuer die Datenerfassung
    
    while(1) 
    {
       //-------------------------------------------
       // Prüfen ob Zeichen eingegeben wurden
       
       get_line();
       
       //-------------------------------------------
       // timer 0 steuert die LED
       
       if (down_timer.GetTimerStatus(0) == 0)
       {
          down_timer.SetCountdownTimer(0,1,500);
          LED5 = !LED5;
       }
       
       //-------------------------------------------
       // timer 1 steuert den one wire bus       
       /*
       if (down_timer.GetTimerStatus(1) == 0)
       {       
            switch (ds1820_status)
            {
                case 0 :
                        // Temperaturwandler starten und 0,8 sek. warten
                        // Start conversion for all DS1820 sensors
                        // pc.printf("\ntrigger one wire bus");
                        
                        ow.ds1820_start_conversion(0xFF);   // alle Bausteine am Bus triggern
                        
                        // Delay until conversion is completed
                        down_timer.SetCountdownTimer(1,1,750); // Timer = 750ms
                                    
                        // beim nächsten Auruf die Temperatur lesen
                        ds1820_status = 1;
                                    
                        break;

                case 1  :   // Temperatur von Temperaturfühler 1  lesen und 0,05 sek. warten
                case 2  :   // Temperatur von Temperaturfühler 2  lesen und 0,05 sek. warten            
                case 3  :   // Temperatur von Temperaturfühler 3  lesen und 0,05 sek. warten
                case 4  :   // Temperatur von Temperaturfühler 4  lesen und 0,05 sek. warten
                case 5  :   // Temperatur von Temperaturfühler 5  lesen und 0,05 sek. warten
                case 6  :   // Temperatur von Temperaturfühler 6  lesen und 0,05 sek. warten
                case 7  :   // Temperatur von Temperaturfühler 7  lesen und 0,05 sek. warten
                case 8  :   // Temperatur von Temperaturfühler 8  lesen und 0,05 sek. warten
                case 9  :   // Temperatur von Temperaturfühler 9  lesen und 0,05 sek. warten
                case 10 :   // Temperatur von Temperaturfühler 10 lesen und 0,05 sek. warten
                case 11 :   // Temperatur von Temperaturfühler 11 lesen und 0,05 sek. warten
                case 12 :   // Temperatur von Temperaturfühler 12 lesen und 0,05 sek. warten
                case 13 :   // Temperatur von Temperaturfühler 13 lesen und 0,05 sek. warten
                case 14 :   // Temperatur von Temperaturfühler 14 lesen und 0,05 sek. warten
                case 15 :   // Temperatur von Temperaturfühler 15 lesen und 0,05 sek. warten
                case 16 :   // Temperatur von Temperaturfühler 16 lesen und 0,05 sek. warten
                                    
                            // Write temperature of all registered sensors
                            uint8_t pos = ds1820_status - 1;
                            if ((ow.ow.device_table[pos].status & 0x0f) != 0)
                            {
                              ow.ow.device_table_index = pos;
                              ow.ds18B20_read_hrtemp();
                              // pc.printf(" %2.2f; ",ow.ow.device_table[pos].value);
                            }

                            ds1820_status++;
                            if (ds1820_status > OW_MAX_DEVICES) 
                            {
                              ds1820_status = 0;
                              down_timer.SetCountdownTimer(1,2,10); // Timer deakivieren
                              // pc.printf("\nexit one wire bus");   
                            }
                            else
                              down_timer.SetCountdownTimer(1,1,10); // 10 ms Timer
                            
                            break;
                                                                                                                                                                                
            } // end switch
       }  // if (down_timer
       
       */
       //-------------------------------------------
       // timer 2 steuert die Datenausgabe
       
       if (down_timer.GetTimerStatus(2) == 0)
       {
            down_timer.SetCountdownTimer(2,1,500);
            
            //------------------------------------------------------
            // PT1000 lesen und berechnen und ausgeben
            // 16 mal den Eingang fuer eine bessere Mittelung lesen
            //
           
            temp_word = read_mw(0);
            temp_float = (temp_word - 28500);
            
            //pc.printf("%d;",temp_word);
            
            temp_float /= 116;
            pc.printf("%0.2f; ",temp_float);                     // Rohdaten ausgeben

            temp_diff = 40 - temp_float;
            
            
  
            temp_neu = ((temp_diff*0.0005) + (temp_alt*0.9));
            
            if(temp_neu > 0.02){
                temp_neu = 0.02;
            }            
            //if(temp_neu < -0.001){
            //    temp_neu = -0.001;
            //}
            if(temp_float > 40){
                temp_neu = 0.0;
                }
            
            heizung.pulsewidth(0.0001 + temp_neu);
            pc.printf("%0.4f;",temp_alt);
            pc.printf("%0.4f \n",temp_neu);
            
            temp_alt = temp_neu;

            temp_word = read_mw(1);
            temp_float = (temp_word - 17210);
            temp_float /= 70;
            // pc.printf("%0.2f\n",temp_float);                      // Rohdaten ausgeben

            
             
       
            //------------------------------------------------------
            // one wire Daten lesen und ausgeben
            /*
            for (n = 0; n < OW_MAX_DEVICES; n++)                // Ausgabe der Daten
            {  
               if ((ow.ow.device_table[n].status & 0x0f) == 3)  // Daten wurden gelesen
               {
                 pc.printf("#%d %d\n",(n+20), ow.ow.device_table[n].result);
                 ow.ow.device_table[n].status = 2;
               }
            }
            
            down_timer.SetCountdownTimer(1,1,10);                // Messung neu starten
            */
       } // end if(down_timer ...
                            
    } // end while
}

