//--------------------------------------------------------
//  SPI を使って WS2812B を点灯するためのクラス（ヘッダ）
//      サポートするボード： Nucleo-F401RE, Nucleo-F446RE
//
//  2016/11/21, Copyright (c) 2016 MIKAMI, Naoki
//--------------------------------------------------------

#include "mbed.h"

#ifndef STM32F4xx_WS2812B_HPP
#define STM32F4xx_WS2812B_HPP

enum RGB {B,G,R};

class WS2812B
    {
    public:
        // コンストラクタ
        //      inv = true:  インバータを介して WS2812B に接続する場合
        //          = false: 直接 WS2812B に接続する場合
        WS2812B(PinName pin, int num, bool inv = false);

        virtual ~WS2812B() {}

        void Send();                   // LED へ書き込む
        void Write(uint32_t x,double brightness = 1.0);         // 一つの LED へ書き込む
        void Write(int index,uint32_t x,double brightness = 1.0);  // k 個の LED へ書き込む
        void Reset() { wait_us(50); }
        void Clear(int k);              // k 個の LED を消灯
        void Brightness(double brightness);
        uint32_t BrightAdjust(uint32_t x,double brightness);
        void Normalize(bool a = true);

    private:
        uint32_t *colors;
        int bufferSize;
        double bright;
        bool normalize;
    
        SPI spi_;
        SPI_TypeDef *mySpi_;

        void (WS2812B::*fp)(uint8_t);
        void SendByte(uint8_t x) { (this->*fp)(x); }
        void Send3Bytes(uint16_t x0, uint16_t x1, uint16_t x2);
        void T0HL() { Send3Bytes(0b11111111, 0b0, 0b0); }   // 0 を送る
        void T1HL() { Send3Bytes(0b11111111, 0b11111111, 0b0); }   // 1 を送る
        void SendByteNorm(uint8_t x);   // データをそのまま送る
        void SendByteInv(uint8_t x);    // データを反転して送る
        
        uint8_t getRGB(uint32_t color,RGB rgb);
        uint32_t NormalizeAdjust(uint32_t x);

        // コピー･コンストラクタと代入演算子は使用禁止
        WS2812B(const WS2812B&);
        WS2812B& operator=(const WS2812B&);
};
#endif