#include "mbed.h"
#include <stdlib.h>

#include "WS2812B.h"

#define BUF 60
#define BUF2 42

int buf[3] = {BUF,BUF,BUF2};
WS2812B tape[2] = {
    WS2812B(PB_0,BUF),
    WS2812B(PC_1,BUF)/*,
    WS2812B(PC_0,BUF2)*/
};

int brightness[2];
Thread sendTh;

uint32_t colors[] = {0xFF0000,0x00FF00,0x0000FF,0xFFFF00,0xFF00FF,0x00FFFF,0xFFFFFF};

void SendingLED()
{
    while (1) {
        for (int t = 0; t < 2; t++) tape[t].Send();
        wait_us((1000 / 60)*1e3);
    }
}

int main()
{
    printf("\r2020 S-Home Christmas!!!\n\r");
    sendTh.start(SendingLED);

    for (int t = 0; t < 2; t++) tape[t].Write(0xFFFFFF);
    wait_us(0.3 * 1e6);
    for (int t = 0; t < 2; t++) tape[t].Write(0);

    double sita[2][BUF] = {0};
    uint32_t c[2][BUF] = {0};
    for (int i = 0; i < 2; i++) {
        for (int j = 0; j < BUF; j++) {
            sita[i][j] = fmod(rand()/1000.0,(double)PI * 3);// + PI * (j % 3);//(,PI);
            c[i][j] = rand() % 7;
        }
    }
    //float sita = 0;
    while (1) {
        for (int t=0; t < 2; t++) {
            for (int i = 0; i < buf[t]; i++) {
                if (sita[t][i] == 0) c[t][i] = rand() % 7;

                float s = 0;
                if (sita[t][i] > 0 && sita[t][i] < PI)s = sin(sita[t][i]);
                tape[t].Write(i,colors[c[t][i]],s);

                sita[t][i] += 0.03f;
                if (sita[t][i] > PI * 3) sita[t][i] = 0;
            }
        }
        wait_us(0.01 * 1e6);
    }
}