//ブラシモータ四輪メカナム用制御プログラム
#include "mbed.h"
#include "Serial_16B.h"

/*----- ----- -----define----- ----- -----*/
#define OPERATING_CYCLE_TIME_US 500//制御周期マイクロ秒
#define PI 3.141592
#define CONTROLLER_SERIAL_DATA_SIZE 4
/*----- ----- -----define----- ----- -----*/

/*----- ----- -----mbedクラス----- ----- -----*/
Serial_16B controller(p9,p10);//コントローラシリアル
Serial pc(USBTX,USBRX);
//pwm_duty
PwmOut motor1_Pulse(p22);//右前
PwmOut motor2_Pulse(p24);//左前
PwmOut motor3_Pulse(p25);//左後ろ
PwmOut motor4_Pulse(p26);//右後ろ

//pwm方向信号
DigitalOut motor1_Direction(p29);//右前
DigitalOut motor2_Direction(p19);//左前
DigitalOut motor3_Direction(p28);//左後ろ
DigitalOut motor4_Direction(p27);//右後ろ

Timer operating_timer;//制御周期管理

DigitalIn ems_sw(p5);
//デバッグ用
DigitalOut L1(LED1);
DigitalOut L3(LED3);
/*----- ----- -----mbedクラス----- ----- -----*/

/*----- ----- -----制御変数----- ----- -----*/
bool EMS = false;
//移動用
bool moving_flag = false;//移動中
int speed = 0;//並進速度
int angle_trans = 0;//並進角度
int angle_machine = 0;//機体角度
float motor1_pulse_tmp = 0;
float motor2_pulse_tmp = 0;
float motor3_pulse_tmp = 0;
float motor4_pulse_tmp = 0;
bool motor1_direction_tmp = 0;
bool motor2_direction_tmp = 0;
bool motor3_direction_tmp = 0;
bool motor4_direction_tmp = 0;
//シリアル通信用
unsigned char data_buf[CONTROLLER_SERIAL_DATA_SIZE];
bool get_start_flag = false;
int get_address = 0;
/*----- ----- -----制御変数----- ----- -----*/

/*----- ----- -----自作関数----- ----- -----*/
void motor_signal_create(float& duty,bool& direction);
void serial_receive();
bool Decode();
/*----- ----- -----自作関数----- ----- -----*/


int main() 
{
    operating_timer.stop();
    operating_timer.reset();
    controller.baud(38400);
    motor1_Pulse.period_us(100);
    
    while(1) 
    {
        operating_timer.start();
        
        serial_receive();
        L1 = moving_flag;
        
        EMS = !ems_sw;//手抜き
        L3 = EMS;
        if(!EMS)
        {
            
            if(moving_flag)
            {
                motor1_pulse_tmp = sin(((angle_trans + 45)%360)*PI/180)*(speed/100.0);
                motor2_pulse_tmp = cos(((angle_trans + 45)%360)*PI/180)*(speed/100.0);
                motor3_pulse_tmp = sin(((angle_trans + 45)%360)*PI/180)*(speed/100.0);
                motor4_pulse_tmp = cos(((angle_trans + 45)%360)*PI/180)*(speed/100.0);
                motor_signal_create(motor1_pulse_tmp,motor1_direction_tmp);
                motor_signal_create(motor2_pulse_tmp,motor2_direction_tmp);
                motor_signal_create(motor3_pulse_tmp,motor3_direction_tmp);
                motor_signal_create(motor4_pulse_tmp,motor4_direction_tmp);
                
                motor1_Pulse = motor1_pulse_tmp;
                motor2_Pulse = motor2_pulse_tmp;
                motor3_Pulse = motor3_pulse_tmp;
                motor4_Pulse = motor4_pulse_tmp;
                motor1_Direction = motor1_direction_tmp;
                motor2_Direction = motor2_direction_tmp;
                motor3_Direction = motor3_direction_tmp;
                motor4_Direction = motor4_direction_tmp;
            }
            else
            {
                motor1_Pulse = 0;
                motor2_Pulse = 0;
                motor3_Pulse = 0;
                motor4_Pulse = 0;
            }
        }
        else
        {
            motor1_Pulse = 0;
            motor2_Pulse = 0;
            motor3_Pulse = 0;
            motor4_Pulse = 0;
        }
        while(operating_timer.read_us() < OPERATING_CYCLE_TIME_US);
        operating_timer.stop();
        operating_timer.reset();
    }
}


/*----- ----- -----自作関数----- ----- -----*/
//デューティー丸め、方向信号演算
void motor_signal_create(float& duty,bool& direction)
{
    if(duty >= 0)
    {
        duty = duty;
        direction = false;
    }
    if(duty < 0)
    {
        duty = -duty;
        direction = true;
    }
}
//
void serial_receive()
{
    while(controller.readable())//データが受信できる間回し続ける
    {     
        unsigned char get_data = controller.get();
            L3=false;
        if((get_data&0x80)==0x80)//先頭byteかどうか判定する。（先頭byteのmsbは、後続byteのmsbは0と約束しておく。）
        {     
            get_address = 0;
            data_buf[0] = get_data;
            get_start_flag = true;
            get_address++;
        }
        else if(get_start_flag)//先頭アドレスが受け取り済みかどうか？
        {     
            data_buf[get_address] = get_data;
            get_address++;
                
            if(get_address >= CONTROLLER_SERIAL_DATA_SIZE)//予定量受信したらDecodeする
            {
                get_start_flag = false;
                get_address = 0;  
                Decode();
            }
        }       
    }
}

bool Decode()
{
    /*シリアル規約
    **0 1CCC CCCC
    **1 0EFG AAAA(上位
    **2 0000 AAAA(下位
    **3 0SSS SSSS
    **4 0
    **5 0
    **6 0
    E...EMS
    F...angle_sign(trueのとき+)
    G...moving_flag
    */
    unsigned char check_sum = 0;
    for(int i=1; i<=CONTROLLER_SERIAL_DATA_SIZE-1; i++)
    {
        check_sum += data_buf[i];
    }
        
    if((check_sum&0x7f) != (data_buf[0]&0x7f))
    {
        return false;
    }
    else
    {
        angle_trans = 0;
        angle_trans += (data_buf[1] & 0x0F) << 4;
        angle_trans += (data_buf[2] & 0x0F);
        angle_trans = (data_buf[1]&0x20)? angle_trans: -angle_trans;
        speed = (data_buf[3] & 0x7F);
        EMS = data_buf[1] & 0x40;
        moving_flag = data_buf[1] & 0x10;
    }
    //pc.printf("%4d, %4d,\r\n",angle_trans,speed);
    return true; 
}