/*******************************************************************
 * TFT Sample program for STEM project
 * By Henry Foley, Feb 2017
 *
 * Hardware: Freedom KL25Z uC development board with a TFT 2.8"
 * resistive touch display shield from Adafruit (1651).
 *
 */

#include "mbed.h"
#include "ILI9341.h"
#include "SPI_STMPE610.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "Verdana22x21-16.h"

#define PIN_XP          PTB3
#define PIN_XM          PTB1
#define PIN_YP          PTB2
#define PIN_YM          PTB0
#define PIN_MOSI        PTD2
#define PIN_MISO        PTD3
#define PIN_SCLK        PTD1
#define PIN_CS_TFT      PTD0
#define PIN_DC_TFT      PTD5
#define PIN_BL_TFT      PTC9
#define PIN_CS_SD       PTA4
#define PIN_CS_TSC      PTA13
#define PIN_RESET_TFT   PTB10  



DigitalOut backlight(PTA12) ;

SPI_STMPE610 TSC(PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TSC) ;

ILI9341 TFT(SPI_8, 10000000,
            PIN_MOSI, PIN_MISO,  PIN_SCLK,
            PIN_CS_TFT, PIN_RESET_TFT, PIN_DC_TFT, "Adafruit2.8") ;
            
void initTFT(void);
void drawScreen(void);
uint16_t map(uint16_t, uint16_t, uint16_t, uint16_t, uint16_t);
void display_xy(void);

int main()
{
    static uint16_t x, y, z ;
    uint16_t temp_x;
    int touched = 0;

    initTFT() ;

    drawScreen();
     
    while(true)
    {
        touched = TSC.getRAWPoint(&x, &y, &z);
        
        if(touched)  // any touch
        {
                
            // scale the raw values to match the screen orentation and 320(x = horiz) 240(y = vert) size, 0,0 = upper left corner
            temp_x = x;
            x = map(y,180, 3800,0,320);
            y = map(temp_x,3800,280,0,240);
            if( (x > 0 && x < 320) && ( y > 0 && y < 240 ))  // if valid values
            {
                drawScreen();
                
                TFT.BusEnable(true) ;
                TFT.background(Blue);
                wait(0.2);
                TFT.foreground(White);
                TFT.locate(120, 160);
                TFT.printf("x%3d", x);
                TFT.locate(120, 190);
                TFT.printf("y%3d", y);                
                TFT.BusEnable(false) ;
                wait(0.5); // to reduce mutiple hits from one touch
            }
        
        } 
    }
} // end of main()

void initTFT(void)
{
    //Configure the display driver
    TFT.BusEnable(true) ;
    TFT.set_orientation(1);
    backlight = 1 ;
    TFT.background(Blue);
    wait(0.2);
    TFT.foreground(White);
    wait(0.2);
    TFT.cls();
    wait(0.2);
    TFT.set_font((unsigned char*) Arial28x28);
    wait(0.2);
    TFT.locate(15, 10);
    TFT.printf("  TFT Test  ");
    TFT.locate(15, 100);
    TFT.BusEnable(false);
    wait(5);
}


void drawScreen(void)
{
    TFT.BusEnable(true);
    TFT.foreground(White);  // Set default text colors
    TFT.background(Blue);
    TFT.cls();              // wipe the screen clean and set bg colors
    wait(0.1);

    TFT.foreground(Black);
    TFT.set_font((unsigned char*) Arial24x23);
    TFT.fillcircle(  60, 175, 50, Yellow);
    TFT.background(Yellow) ;
    TFT.locate(25, 160);
    TFT.printf(" A ");

    TFT.fillcircle( 160, 105, 50, Cyan);
    TFT.background(Cyan) ;
    TFT.locate(127, 92);
    TFT.printf(" B ");

    TFT.fillcircle( 260, 175, 50, Green);
    TFT.background(Green) ;
    TFT.locate(222, 160);
    TFT.printf("  C  ");
    
    TFT.fillcircle( 60, 60, 50, Orange);
    TFT.background(Orange) ;
    TFT.locate(15, 50);
    TFT.printf("  D  ");
    
    TFT.fillcircle( 260, 60, 50, GreenYellow);
    TFT.background(GreenYellow) ;
    TFT.locate(225, 50);
    TFT.printf("  E  ");   

    TFT.BusEnable(false) ;
}

// mapping function to change the orentation of the screen to horizontal
uint16_t map(uint16_t x, uint16_t in_min, uint16_t in_max, uint16_t out_min, uint16_t out_max)
{
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

// Code used to debug screen orentation and touch pad
void display_xy(void)
{
    static uint16_t x, y, z ;
    uint16_t temp_x;
    int touched = 0;

    while(true) {
        touched = TSC.getRAWPoint(&x, &y, &z);

        x = x & 0x7f;
        y = y & 0x7f;
        
        if(x) { // any touch
            wait(0.5);
            TFT.BusEnable(true);
            TFT.locate(5, 40);
            TFT.printf("x= %5d x=%4X", x, x);
            TFT.locate(5, 80);
            TFT.printf("y= %5d y=%4X", y, y);
 //           TFT.locate(5, 120);
 //           TFT.printf("raw z%6d  z%4X", z, z);           

            // scale the raw values to match the screen orentation and 320(x = horiz) 240(y = vert) size
            // 0,0 = upper left corner
            temp_x = x;
            x = map(y,180, 3800,0,320);              // TFT.set_orientation(1);
            y = map(temp_x,3800,280,0,240);

//          x = map(y,3800, 180,0,320);              // TFT.set_orientation(3);
//          y = map(temp_x,280,3800,0,240);

            TFT.locate(5, 120);
            TFT.printf("map x%5d y%5d", x, y);
 
            TFT.BusEnable(false);
            wait(0.5);
        }
    }
}
    