#include "mbed.h"
#include "tsi_sensor.h"

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif

//elaciono palabras con numeros
#define verificacion 0
#define inicio 0
#define accion 1
#define eleccion 2
#define pata 3
#define estado 4
#define verificacionA 5
#define verificacionB 6
#define fin 7
#define escritura 1
#define leida 2

/*
lista de combinaciones y sus respectivos numeros hexagesimales:
WLR0 ---->  79
WLR1 ---->  78
WLG0 ---->  6c
WLG1 ---->  6d
WLB0 ---->  69
WLB1 ---->  68
RLB- ---->  71
RLG- ---->  74
RLR- ---->  61
RA0- ---->  0e
RA1- ---->  0f
RI0- ---->  06
RI0- ---->  07
*/
//defino entradas y salidas
DigitalOut rojo(LED_RED);
DigitalOut verde(LED_GREEN);
DigitalOut azul(LED_BLUE);
AnalogIn preset(A0);
DigitalIn entrada1(D2);
DigitalIn entrada2(D3);
TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
//Creamos los tres leds pra usar
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

//Definimos que el puerto serie se llama pc
Serial pc(USBTX, USBRX);
//Variable donde se guarda lo leido
char   c = '\0';
//bit usado como flag para procesar datos
bool newdata = false;   //Se pone en true cuando hay nuevos datos

//Callback cuando se detecta una entrada
void onCharReceived()
{
    //Copiamos lo leido en c
    c=pc.getc();
    newdata = true;
}
//defino funcion principal
void correo();
//defino variables a usar
char lectura=0, accione=0, action=0, sondeo=0, reinicio=0, x=0,trama[9], exorcismo=0, examenA=0, examenB=0, bloqueo1=0;
char exa[17]= {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};

int main()
{
//Apagamos los leds
    rojo = 1;
    verde = 1;
    azul = 1;
//Ejecutar onCharReceived por cada entrada por puerto
    pc.attach(&onCharReceived);

    while (true) {
        correo();//llamo a la funcion
    }
}
/*----------------------funcion principal-------------------------------------*/
void correo()
{
    switch(lectura) {//maquina de estados principal
        /* cuando debo verificar cada dato que recibo de la PC */
        default:
        case verificacion:
            if(newdata) {//cuando recibo datos de la PC
                newdata = false;
                switch(sondeo) {// maquina de estados cada vez que recibo un dato y verifico si esta bien el protocolo enviado
                    default:
                    case inicio://bit de inicio
                        if(c=='$') {// si el bit es correcto
                            trama[0]=c;// agrego lo recibido en un vector
                            sondeo=accion;// paso a la siguiente maquina de estado
                        }
                        break;

                    case accion:// bit de leida o de escritura
                        if(c=='W'||c=='R') {// si recibo W o R
                            trama[1]=c;// agrego lo recibido en un vector
                            if(c=='W')// si el bit es W
                                action=escritura;//defino la accion que se hara despues de comprobar 
                            else if(c=='R')
                                action=leida;//defino la accion que se hara despues de comprobar 
                            sondeo=eleccion;// paso a la siguiente maquina de estado
                        } else
                            sondeo=inicio;// si el bit no es el deseado, vuelvo al inicio de espera del bit de inicio
                        break;

                    case eleccion://bit de led, analogica y digital
                        if(c=='L'||c=='A'||c=='I') {// si reibo los bits deseados
                            trama[2]=c;// agrego lo recibido en un vector
                            sondeo=pata;// paso a la siguiente maquina de estado
                        } else
                            sondeo=inicio;// si el bit no es el deseado, vuelvo al inicio de espera del bit de inicio
                        break;

                    case pata:// bit de pata o led a modificar
                        if(c=='R'||c=='G'||c=='B'||c=='0'||c=='1') {// si recibo los bits deseados
                            trama[3]=c;// agrego lo recibido en un vector
                            sondeo=estado;// paso a la siguiente maquina de estado
                        } else
                            sondeo=inicio;// si el bit no es el deseado, vuelvo al inicio de espera del bit de inicio
                        break;

                    case estado:// bit de estado de led o nada 
                        if(c=='0'||c=='1'||c=='-') {// si recibo los bits deseados
                            trama[4]=c;// agrego lo recibido en un vector
                            sondeo=verificacionA;// paso a la siguiente maquina de estado
                        } else
                            sondeo=inicio;// si el bit no es el deseado, vuelvo al inicio de espera del bit de inicio
                        break;

                    case verificacionA:// bit de verificacion
                        if(c=='A'||c=='B'||c=='C'||c=='D'||c=='E'||c=='F'||c=='0'||c=='1'||c=='2'||c=='3'||c=='4'||c=='5'||c=='6'||c=='7'||c=='8'||c=='9') {// si recibo los bits deseados
                            trama[5]=c;// agrego lo recibido en un vector
                            sondeo=verificacionB;// paso a la siguiente maquina de estado
                        } else
                            sondeo=inicio;// si el bit no es el deseado, vuelvo al inicio de espera del bit de inicio
                        break;

                    case verificacionB:// bit de verificacion
                        if(c=='A'||c=='B'||c=='C'||c=='D'||c=='E'||c=='F'||c=='0'||c=='1'||c=='2'||c=='3'||c=='4'||c=='5'||c=='6'||c=='7'||c=='8'||c=='9') {// si recibo los bits deseados
                            trama[6]=c;// agrego lo recibido en un vector
                            sondeo=fin;// paso a la siguiente maquina de estado
                        } else
                            sondeo=inicio;// si el bit no es el deseado, vuelvo al inicio de espera del bit de inicio
                        break;

                    case fin:// bit de fin
                        trama[7]=c;// agrego lo recibido en un vector
                        if(c=='!') {// si recibo el bit deseados
                            bloqueo1=0;// reseteo bloqueo
                            exorcismo= trama[1] ^ trama[2] ^ trama[3] ^ trama[4];// hago un xor con los bits que recibo 
                            examenA= exorcismo % 16;//convierto el el resultado de xor a hexagesimal
                            examenB= exorcismo / 16;//convierto el el resultado de xor a hexagesimal
                            sondeo=inicio;// reseteo la maquina de estados de verificacion
                        } else
                            sondeo=inicio;// si el bit no es el deseado, vuelvo al inicio de espera del bit de inicio
                        break;
                }
                break;
            }
            if(trama[5]==exa[examenB] && trama[6]==exa[examenA] && trama[7]=='!' && bloqueo1==0) {// si la verificacion es correcta y se termino de leer el protocolo
                bloqueo1=1;//se usa para que solo para que solo se entre una vez y no se repita hasta que no se termine de leer el protocolo completo
                if(action==escritura)//si se decidio escribir
                    lectura=escritura;// despues de leer el protocolo paso a escribir
                else if(action==leida)// si se decidio leer
                    lectura=leida;// despues de leer el protocolo paso a leer
            } else if(trama[5]!=exa[examenB] && trama[6]!=exa[examenA] && trama[7]=='!' && bloqueo1==0) {// si la verificacion es incorrecta y se termino de leer el protocolo
                bloqueo1=1;//se usa para que solo para que solo se entre una vez y no se repita hasta que no se termine de leer el protocolo completo
                printf("Ah ,ah ,ah. No dijiste la palabra magica \r\n");
                lectura=sondeo;// si la verificacion es incorecta, vuelvo al inicio de la verificacion
            }
            break;
        
        case leida:// maquina de estado para leer
            if(trama[1]=='R' && trama[2]=='L' && trama[3]=='B' && trama[4]=='-') {// si quiero saber el estado del led azul
                if(azul==1)// si el led esta encendido
                    printf("$RLB0!");
                else// si el led esta apagado
                    printf("$RLB1!");
            } else if(trama[1]=='R' && trama[2]=='L' && trama[3]=='G' && trama[4]=='-') {// si quiero saber el estado del led verde
                if(verde==1)// si el led esta encendido
                    printf("$RLG0!");
                else// si el led esta apagado
                    printf("$RLG1!");
            } else if(trama[1]=='R' && trama[2]=='L' && trama[3]=='R' && trama[4]=='-') {// si quiero saber el estado del led rojo
                if(rojo==1)// si el led esta encendido
                    printf("$RLR0!");
                else// si el led esta apagado
                    printf("$RLR1!");
            } else if(trama[1]=='R' && trama[2]=='A' && trama[3]=='0' && trama[4]=='-')// si quiero saber el valor del preset o Analog0
                printf("$RA0-%1.1f!\n\r",preset.read());
            else if(trama[1]=='R' && trama[2]=='A' && trama[3]=='1' && trama[4]=='-')// si quiero saber el valor del tsi o Analog1
                printf("$RA1-%1.1f!\n\r",tsi.readPercentage());
            else if(trama[1]=='R' && trama[2]=='I' && trama[3]=='0' && trama[4]=='-')// si quiero saber el estado de la entrada digital 0
                printf("$RI0-%d!\n\r",entrada1.read());
            else if(trama[1]=='R' && trama[2]=='I' && trama[3]=='1' && trama[4]=='-')// si quiero saber el estado de la entrada digital 1 
                printf("$RI1-%d!\n\r",entrada2.read());
            lectura=verificacion;
            break;

        case escritura:// maquina de estado para escribir
            if(trama[1]=='W' && trama[2]=='L' && trama[3]=='R' && trama[4]=='0')// si quiero apagar el led rojo
                rojo=1;// apago led rojo
            else if(trama[1]=='W' && trama[2]=='L' && trama[3]=='R' && trama[4]=='1')// si quiero encender el led rojo
                rojo=0;// enciendo led rojo
            else if(trama[1]=='W' && trama[2]=='L' && trama[3]=='G' && trama[4]=='0')// si quiero apagar el led verde
                verde=1;// apago led verde
            else if(trama[1]=='W' && trama[2]=='L' && trama[3]=='G' && trama[4]=='1')// si quiero encender el led verde
                verde=0;// enciendo led verde
            else if(trama[1]=='W' && trama[2]=='L' && trama[3]=='B' && trama[4]=='0')// si quiero apagar el led azul
                azul=1;// apago led azul
            else if(trama[1]=='W' && trama[2]=='L' && trama[3]=='B' && trama[4]=='1')// si quiero encender el led azul
                azul=0;// enciendo led azul
            lectura=verificacion;// vuelvo a la maquina de estado de verificacion
            break;
    }
}
