#include "mbed.h"
#include <stdio.h>
#include <stdlib.h>

#define CERO   0b1111110
#define UNO    0b0110000
#define DOS    0b1101101
#define TRES   0b1111001
#define CUATRO 0b0110011
#define CINCO  0b1011011
#define SEIS   0b1011111
#define SIETE  0b1110000
#define OCHO   0b1111111
#define NUEVE  0b1110011

#define inicio 0
#define rendam 1
#define seleccion 2
#define verificacion 3

#define bomba0 0
#define bomba1 1
#define bomba2 2
#define bomba3 3

/* defino mis patas de bus de datos que voy a utilizar para manejar los displays */
BusOut displays(D2,D3,D4,D5,D6,D7,D8); // G-F-E-D-C-B-A

/* defino mis variables, ticker y las funciones para los displays-------- ademas defino 2 salidas para la conmutacion de los 2 displays */
char regresivo=0, parar=1,variable=0,conmutador=0;
int cuentaregre=0, unidad=0, decena=0;
Ticker ti;
void cuentaregresiva();
void cuentitaregresiva();
DigitalOut unida(D9,0);
DigitalOut decen(D10,0);

/* defino el led rojo y verde ,y las inicializo en "OFF" */
DigitalOut rojo(LED_RED,1);
DigitalOut verde(LED_GREEN,1);

/* defino mi pulsador de inicio y reseteo  */
void contador1();
void pulsadorsito1();
char  salida1=0,cuenta1=0, PIN1=0;
Ticker ti1;
DigitalIn pin1(A0,PullUp);

/* defino mi "pulsador" de la bomba0 */
void contador2();
void pulsadorsito2();
char  salida2=0,cuenta2=0, PIN2=0;
Ticker ti2;
DigitalIn pin2(A2,PullUp);

/* defino mi "pulsador" de la bomba1 */
void contador3();
void pulsadorsito3();
char  salida3=0,cuenta3=0, PIN3=0;
Ticker ti3;
DigitalIn pin3(A3,PullUp);

/* defino mi "pulsador" de la bomba2 */
void contador4();
void pulsadorsito4();
char  salida4=0,cuenta4=0, PIN4=0;
Ticker ti4;
DigitalIn pin4(A4,PullUp);

/* defino mi "pulsador" de la bomba3 */
void contador5();
void pulsadorsito5();
char  salida5=0,cuenta5=0, PIN5=0;
Ticker ti5;
DigitalIn pin5(A5,PullUp);

/* defino mis variables a utilizar en la funcion principal */
void bombucha();
char estado=0, reseteo=0, bloqueo0=0, bloqueo1=0, bloqueo2=0, bloqueo3=0,rondom[4],i=0,ruedam=0, bombuchita=0, desactivacion=0,x=0, bumba=0;

/* ticker random */
Ticker ran;
int ramd=0;
void randoma();

int main()
{
    /* inicializo los numeros random */
    srand(ramd);
    ran.attach(&randoma,0.0001);

    /* inicializo el ticker del pulsador de inicio */
    ti1.attach(&contador1, 0.001);

    /* inicializo los tickers de las bombas */
    ti2.attach(&contador2, 0.001);
    ti3.attach(&contador3, 0.001);
    ti4.attach(&contador4, 0.001);
    ti5.attach(&contador5, 0.001);

    /* inicializo el ticker de la cuenta regresiva */
    ti.attach(&cuentaregresiva, 0.001);

    while(1) {
        /* llamo a las funciones */
        pulsadorsito1();
        pulsadorsito2();
        pulsadorsito3();
        pulsadorsito4();
        pulsadorsito5();
        bombucha();
        cuentitaregresiva();
    }
}
/* funcion principal------------------------------------------------------------ */
void bombucha()
{
    switch(estado) {
        /* cuando apreto el pulsador se inicia el juego y reseteo mis variables */
        case inicio:
            if(salida1==1 && reseteo==0 ) {
                reseteo=1;
                estado = rendam;
                printf("inicio \r\n");
                i=0;
                bloqueo0=0;
                bloqueo1=0;
                bloqueo2=0;
                bloqueo3=0;
                rojo=1;
                verde=1;
            }
            break;

        /* defino en un vector el orden de desconexion de las bombas */
        case rendam:
            if(i<4) {
                /* mientras que aun no haya seleccionado todas las bombas */
                ruedam=rand()%4;
                /* est el bloqueo para asi de esta forma evito que me elija la misma bomba 2 o mas veces */
                if(ruedam==0 && bloqueo0==0) {
                    bloqueo0=1;
                    rondom[i]= bomba0;
                    printf("bomba0 \r\n");
                    i++;
                } else if(ruedam==1 && bloqueo1==0) {
                    bloqueo1=1;
                    rondom[i]= bomba1;
                    printf("bomba1 \r\n");
                    i++;
                } else if(ruedam==2 && bloqueo2==0) {
                    bloqueo2=1;
                    rondom[i]= bomba2;
                    printf("bomba2 \r\n");
                    i++;
                } else if(ruedam==3 && bloqueo3==0) {
                    bloqueo3=1;
                    rondom[i]= bomba3;
                    printf("bomba3 \r\n");
                    i++;
                }
            } else {
                /* cuando termino el orden de las bombas */
                i=0;
                estado=seleccion;
                printf("lista la bomba \r\n");
                bloqueo0=0;
                bloqueo1=0;
                bloqueo2=0;
                bloqueo3=0;
                parar=0;
                unidad=1;
                decena=3;
            }
            break;

        /* mientras que este a tiempo podre desconectar los cables de sus respectivas bombas */
        case seleccion:
            if(parar==0) {
                if(salida2==1 && bloqueo0==0) {
                    bloqueo0=1;
                    estado=verificacion;
                    desactivacion=bomba0;
                } else if(salida3==1 && bloqueo1==0) {
                    bloqueo1=1;
                    estado=verificacion;
                    desactivacion=bomba1;
                } else if(salida4==1 && bloqueo2==0) {
                    bloqueo2=1;
                    estado=verificacion;
                    desactivacion=bomba2;
                } else if(salida5==1 && bloqueo3==0) {
                    bloqueo3=1;
                    estado=verificacion;
                    desactivacion=bomba3;
                } else if(salida1==1 && reseteo==1) {
                    /* si deseo resetear el programa , para poder iniciar de nuevo hay que volver a presionar el mismo boton otra vez */
                    estado=inicio;
                    i=0;
                    x=0;
                    printf("reseteate \r\n");
                    reseteo=0;
                    decena=0;
                    unidad=0;
                    parar=1;
                }
            } else if(parar==1) {
                /* si se agota el tiempo vuel al inicio y explota la bomba*/
                estado=inicio;
                printf("ala hack bar \r\n");
                x=0;
                reseteo=0;
                rojo=0;
                parar=1;
                unidad=0;
                decena=0;
            }
            break;

        case verificacion:
            bumba=rondom[x];
            if(bumba==desactivacion) {
                /* si desconecte correctamente el cable */
                x++;
                if(x==4) {
                    /* en el caso que desconecte correctamente todos los cables  */
                    estado=inicio;
                    x=0;
                    reseteo=0;
                    printf("Bien hecho agente Haunt, salvaste al mundo otra vez \r\n");
                    verde=0;
                    parar=1;
                } else if(x<4) {
                    /* si aun no desconecte todos los cables */
                    estado=seleccion;
                    printf("un cable menos \r\n");
                }

            } else {
                /* en el caso que me equivoque de cable , pierdo directamente */
                estado=inicio;
                printf("ala hack bar \r\n");
                x=0;
                reseteo=0;
                rojo=0;
                parar=1;
                unidad=0;
                decena=0;
            }
            break;
    }
}
/* funcion ticker random */
void randoma()
{
    ramd++;
    srand(ramd);
}
/* funcion cuenta regresiva de los displays------------------------------------------------ */
void cuentitaregresiva()
{
    /* se setea la cuenta de los displays y se va disminuyendo hasta que llegue a cero */
    if(cuentaregre==0 && parar==0 ) {
        /* se varia entre un display y otro 1000 veces por segundo ---- cuando se llega a 1000 , se cumple un segundo*/
        cuentaregre=1000;
        unidad--;
        if(unidad<0) {
            decena--;
            unidad=9;
        }
        if(decena<0)
            decena=9;
        if(unidad==9 && decena==9) {
            parar=1;
            unidad=0;
            decena=0;
        }
    }

    /* se invierten las salidas de las referencias de los displays */
    if(conmutador==0) {
        unida=1;
        decen=0;
        variable=unidad;
    } else {
        unida=0;
        decen=1;
        variable=decena;
    }

    /* cada vez que cambio las referencias , tambien cambio la muestra de unidad y/o decena  */
    switch(variable) {
        default:
        case 0:
            displays=CERO;
            break;
        case 1:
            displays=UNO;
            break;
        case 2:
            displays=DOS;
            break;
        case 3:
            displays=TRES;
            break;
        case 4:
            displays=CUATRO;
            break;
        case 5:
            displays=CINCO;
            break;
        case 6:
            displays=SEIS;
            break;
        case 7:
            displays=SIETE;
            break;
        case 8:
            displays=OCHO;
            break;
        case 9:
            displays=NUEVE;
            break;
    }
}

/* ticker de la cuenta regresiva, cada vez que se entra se invierte la salida de las referencias de los displys */
void cuentaregresiva()
{
    conmutador=!conmutador;
    if(cuentaregre)
        cuentaregre--;
}

//-----------funcion del pulsador de inicio-------------------------------------------------------------------
void pulsadorsito1()
{
    switch(PIN1) {
        default:
        case 0:
            if(pin1==1) {
                salida1=0;
                cuenta1=0;
            } else if(pin1==0) {
                PIN1=1;
                cuenta1=100;
            }
            break;

        case 1:
            if(cuenta1==0 && pin1==1) {
                salida1=1;
                PIN1=0;
            } else if( pin1==1 && cuenta1>0) {
                PIN1=0;
            }
            break;
    }
}

void contador1()
{
    if(cuenta1)
        cuenta1--;
}

//--------------funciones de los "pulsadores" de las bombas----------------------------------------------------------------
void pulsadorsito2()
{
    switch(PIN2) {
        default:
        case 0:
            if(pin2==1) {
                salida2=0;
                cuenta2=0;
            } else if(pin2==0) {
                PIN2=1;
                cuenta2=100;
            }
            break;

        case 1:
            if(cuenta2==0 && pin2==1) {
                salida2=1;
                PIN2=0;
            } else if( pin2==1 && cuenta2>0) {
                PIN1=0;
            }
            break;
    }
}

void contador2()
{
    if(cuenta2)
        cuenta2--;
}
//------------------------------------------------------------------------------
void pulsadorsito3()
{
    switch(PIN3) {
        default:
        case 0:
            if(pin3==1) {
                salida3=0;
                cuenta3=0;
            } else if(pin3==0) {
                PIN3=1;
                cuenta3=100;
            }
            break;

        case 1:
            if(cuenta3==0 && pin3==1) {
                salida3=1;
                PIN3=0;
            } else if( pin3==1 && cuenta3>0) {
                PIN3=0;
            }
            break;
    }
}

void contador3()
{
    if(cuenta3)
        cuenta3--;
}
//------------------------------------------------------------------------------
void pulsadorsito4()
{
    switch(PIN4) {
        default:
        case 0:
            if(pin4==1) {
                salida4=0;
                cuenta4=0;
            } else if(pin4==0) {
                PIN4=1;
                cuenta4=100;
            }
            break;

        case 1:
            if(cuenta4==0 && pin4==1) {
                salida4=1;
                PIN4=0;
            } else if( pin4==1 && cuenta4>0) {
                PIN4=0;
            }
            break;
    }
}

void contador4()
{
    if(cuenta4)
        cuenta4--;
}
//------------------------------------------------------------------------------
void pulsadorsito5()
{
    switch(PIN5) {
        default:
        case 0:
            if(pin5==1) {
                salida5=0;
                cuenta5=0;
            } else if(pin5==0) {
                PIN5=1;
                cuenta5=100;
            }
            break;

        case 1:
            if(cuenta5==0 && pin5==1) {
                salida5=1;
                PIN5=0;
            } else if( pin5==1 && cuenta5>0) {
                PIN5=0;
            }
            break;
    }
}

void contador5()
{
    if(cuenta5)
        cuenta5--;
}