#include "mbed.h"
#include <stdio.h>
#include <stdlib.h>

/*
 *  Si se toca el slider (cerca de la zona izquierda)
 *  enciende / apaga el led rojo
 *
 *  Para FRDM-KL25z
 */

#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif
/* Defino los LEDS RGB  */
DigitalOut rojo(LED_RED);
DigitalOut verde(LED_GREEN);
DigitalOut azul(LED_BLUE);

/* Defino el pulsador de inicio y reseteo  */
void contador1();
void pulsadorsito1();
char  salida1=0,cuenta1=0, PIN1=0;
Ticker ti1;
DigitalIn pin1(A0,PullUp);

/* Defino el pulsador del color verde */
void contador2();
void pulsadorsito2();
char  salida2=0,cuenta2=0, PIN2=0;
Ticker ti2;
DigitalIn pin2(A1,PullUp);


/* Defino el pulsador del color rojo */
void contador3();
void pulsadorsito3();
char  salida3=0,cuenta3=0, PIN3=0;
Ticker ti3;
DigitalIn pin3(A2,PullUp);

/* Defino el pulsador del color azul */
void contador4();
void pulsadorsito4();
char  salida4=0,cuenta4=0, PIN4=0;
Ticker ti4;
DigitalIn pin4(A3,PullUp);


/* Defino las variables del "simon" y el ticker correspondiente */
Ticker ti;
void contador();
void simone();
char cuenta=0,estado=0, rondom=0,randomi[25],rendam=0,i=0, reseteo=0, muestrita=0, secuencita=0,secuence=1, secuenco=0, seleccione=0, verificate=0, validacion=0,a=0,bloqueo=0,x=0,randomizate=0,veric=0, bloqueo1=0, bloqueo2=0, bloqueo3=0;

/* ticker random */
Ticker ran;
int ramd=0;
void randoma();

#define inicio 0
#define random 1
#define muestra 2
#define secuencia 3
#define seleccion 4
#define verificacion 5

#define rojito 0
#define azulcito 1
#define verdecito 2

#define verdale 0
#define rojale 1
#define azulale 2
#define reseteale 3

int main()
{
    /* inicializo los numeros random */
    srand(ramd);
    ran.attach(&randoma,0.0001);

    /* seteo en off para los leds */
    rojo=1;
    verde=1;
    azul=1;

    /* defino los tickers  */
    ti.attach(&contador, 0.01);
    ti1.attach(&contador1, 0.001);
    ti2.attach(&contador2, 0.001);
    ti3.attach(&contador3, 0.001);
    ti4.attach(&contador4, 0.001);

    /* inicializo los numeros random */
    srand (time(NULL));
    while(1) {

        /* llamo a las funciones */
        pulsadorsito1();
        pulsadorsito2();
        pulsadorsito3();
        pulsadorsito4();
        simone();
    }
}
//---------funcion del juego simon----------------------------------------------
void simone()
{
    /* maquina de estados */
    switch(estado) {
        /* indico cuando toco el pulsador inicio el del juego y reseteo todas las variables */
        case inicio:
            if(salida1==1 && reseteo==0) {
                reseteo=1;
                estado=random;
                printf("inicio \r\n ");
                i=0;
                secuence=1;
                rojo=1;
                verde=1;
                azul=1;
            }
            break;

        /* incio la secuencia random y la guardo en un vector  */
        case random:
            if(cuenta==0) {
                rendam=rand()%3;
                if(i<24) {
                    if(rendam==rojito) {
                        randomi[i]=rojito;
                        i++;
                    } else if(rendam==azulcito) {
                        randomi[i]=azulcito;
                        i++;
                    } else if(rendam==verdecito) {
                        randomi[i]=verdecito;
                        i++;
                    }
                } else {
                    /* cuando se termina de establecer la secuencia random*/
                    estado=secuencia;
                    i=0;
                    cuenta=100;
                    printf("secuencia \r\n");
                }
            }
            break;

        /* cuando es necesario mostrar la secuencia a seleccionar  */
        case muestra:
            /* cuando se termina de mostrar lo seleccionado */
            if(secuencita==1 && cuenta==0) {
                rojo=1;
                verde=1;
                azul=1;
                estado=secuencia;
                secuencita=0;
                rondom=0;
                cuenta=50;
            } else if(cuenta) {
                /* mientras que el tiempo sea indistinto a 0 */
                if(secuencita==1)
                    muestrita = secuenco;
                /* enciendo el led correspondiente */
                switch(muestrita) {
                    case rojito: {
                        rojo=0;
                        verde=1;
                        azul=1;
                        break;
                    }
                    case verdecito: {
                        rojo=1;
                        verde=0;
                        azul=1;
                        break;
                    }
                    case azulcito: {
                        rojo=1;
                        verde=1;
                        azul=0;
                        break;
                    }
                }
            }
            /* en el caso que desee resetear el programa en el medio de la muestra */
            if(salida1==1 && reseteo==1) {
                reseteo=0;
                estado=inicio;
                rojo=1;
                verde=1;
                azul=1;
            }
            break;

        /* defino mi secuencia a seguir y luego la muestro, esta aumenta por cada vez que gano */
        case secuencia:
            if(cuenta==0) {
                if(i<secuence) {
                    secuenco=randomi[i];
                    estado=muestra;
                    secuencita=1;
                    i++;
                    cuenta=100;
                } else if(i==secuence) {
                    /* cuando termino de mostrar empiezo a seleccionar  */
                    estado=seleccion;
                    printf("Elija con prudencia \r\n");
                }
            }


            break;

        /* dependiendo del pulsador que toque voy a mostrar encendido un led */
        case seleccion:
            switch(a) {
                case verdale:
                    if(salida2 == 1 && bloqueo1==0) {
                        /* cuando presiono enciendo el led correspondiente--- esto se repite con los demas pulsadores */
                        verde =0;
                        printf("apretaste verde \r\n");
                        bloqueo1=1;
                    } else if(salida2==0 && bloqueo1==1) {
                        /* cuando suelto el pulsador envio la informacion del color que elegir--- esto se repite con los demas pulsadores */
                        veric= verdecito;
                        estado=verificacion;
                        bloqueo1=0;
                        verde=1;
                    }
                    a++;
                    break;

                case rojale:
                    if(salida3 == 1 && bloqueo2==0) {
                        rojo =0;
                        printf("apretaste rojo \r\n");
                        bloqueo2=1;
                    } else if(salida3==0 && bloqueo2==1) {

                        veric= rojito;
                        estado=verificacion;
                        bloqueo2=0;
                        rojo=1;
                    }
                    a++;
                    break;

                case azulale:
                    if(salida4 == 1 && bloqueo3==0) {
                        azul =0;
                        printf("apretaste azul \r\n");
                        bloqueo3=1;
                    } else if(salida4==0 && bloqueo3==1) {

                        veric= azulcito;
                        estado=verificacion;
                        bloqueo3=0;
                        azul=1;
                    }
                    a++;
                    break;

                case reseteale:
                    if(salida1==1 && reseteo==1) {
                        /* en el caso que desee resetear el programa en el medio de la seleccion */
                        reseteo=0;
                        estado=inicio;
                        rojo=1;
                        verde=1;
                        azul=1;
                    }
                    a=0;
                    break;
            }
            break;

        /* se verifica lo que elegi */
        case verificacion:
            randomizate=randomi[x];
            /* si le acerte al color */
            if(randomizate == veric) {
                estado=seleccion;
                x++;
            } else {
                /* si le acierto al color */
                x=0;
                estado=inicio;
                reseteo=0;
                rojo=0;
                verde=1;
                azul=1;
                secuence=1;

            }
            /* cuando acierto la secuencia entera */
            if(x==secuence) {
                /* si aun me falta para ganar */
                if(secuence<24) {
                    estado=secuencia;
                    secuence++;
                    x=0;
                    i=0;
                    rojo=1;
                    verde=1;
                    azul=1;
                } else if(secuence==24) {
                    /* si gano al elegir correctamente todas las secuencias */
                    estado=inicio;
                    x=0;
                    rojo=1;
                    verde=0;
                    azul=1;
                    reseteo=0;
                }

            }
            break;
    }
}
/* contador */
void contador()
{
    if(cuenta)
        cuenta--;
}

/* funcion ticker random */
void randoma()
{
    ramd++;
    srand(ramd);
}

//----------------funcion de los 4 pulsadores-----------------------------------------
void pulsadorsito1()
{
    switch(PIN1) {
        default:
        case 0:
            if(pin1==1) {
                salida1=0;
                cuenta1=0;
            } else if(pin1==0) {
                PIN1=1;
                cuenta1=25;
            }
            break;

        case 1:
            if(cuenta1==0 && pin1==1) {
                salida1=1;
                PIN1=0;
            } else if( pin1==1 && cuenta1>0) {
                PIN1=0;
            }
            break;
    }
}

void contador1()
{
    if(cuenta1)
        cuenta1--;
}

//------------------------------------------------------------------------------
void pulsadorsito2()
{
    switch(PIN2) {
        default:
        case 0:
            if(pin2==1) {
                salida2=0;
                cuenta2=0;
            } else if(pin2==0) {
                PIN2=1;
                cuenta2=25;
            }
            break;

        case 1:
            if(cuenta2==0 && pin2==0)
                salida2=1;
            else if(cuenta2==0 && pin2==1)
                PIN2=0;
            else if( pin2==1 && cuenta2>0)
                PIN2=0;
            break;
    }
}

void contador2()
{
    if(cuenta2)
        cuenta2--;
}

//------------------------------------------------------------------------------
void pulsadorsito3()
{
    switch(PIN3) {
        default:
        case 0:
            if(pin3==1) {
                salida3=0;
                cuenta3=0;
            } else if(pin3==0) {
                PIN3=1;
                cuenta3=25;
            }
            break;

        case 1:
            if(cuenta3==0 && pin3==0)
                salida3=1;
            else if(cuenta3==0 && pin3==1)
                PIN3=0;
            else if( pin3==1 && cuenta3>0)
                PIN3=0;
            break;
    }
}

void contador3()
{
    if(cuenta3)
        cuenta3--;
}

//------------------------------------------------------------------------------
void pulsadorsito4()
{
    switch(PIN4) {
        default:
        case 0:
            if(pin4==1) {
                salida4=0;
                cuenta4=0;
            } else if(pin4==0) {
                PIN4=1;
                cuenta4=25;
            }
            break;

        case 1:
            if(cuenta4==0 && pin4==0)
                salida4=1;
            else if(cuenta4==0 && pin4==1)
                PIN4=0;
            else if( pin4==1 && cuenta4>0)
                PIN4=0;
            break;
    }
}

void contador4()
{
    if(cuenta4)
        cuenta4--;
}