
#include "mbed.h"
#include "DS1820.h"
#define DATA_PIN        A0

#define abierto 0
#define minimo 1
#define lineal 2
#define maximo 3
#define error 4



/* defino la funcion principal */
void sensorsito();

/* defino las funciones, ticker y las variables de las vueltas */

void pulsos();


char  hall=0, vueltas=0, arranque=0;
void contador2();
void pulsadorsito2();
char  salida2=0,cuenta2=0, PIN2=0;
Ticker ti2;
DigitalIn pin2(A4,PullUp);

/* defino lo relacionado al sensor de temperatura y el cooler */
DS1820 probe(DATA_PIN);
AnalogIn ADC(A1); // definimos la entrada de ADC
PwmOut velocidad(A2);
int temperatura=0,sensor=1;
uint16_t adcValue; // nos da un rango entre 0-65535
float voltage, porcentageADC,porcentajetemperatura; // definimos el voltaje y el porcentaje

/* defino la fucion , ticker y las variables del pulsador1-- en este caso voy a hacer que la salida se invierta en vez de un pulso  */
void pulsadorsito1();
void contador1();
DigitalIn pin1(A3,PullUp);
char  salida1=0,cuenta1=0, PIN1=0;
Ticker ti1;

int main()
{
    /* defino los tickers */
    ti1.attach(&contador1, 0.001);
    ti2.attach(&contador2, 0.001);
    
    /* frecuencia de PWM del cooler */
    velocidad.period(0.0025f); // 400hz

    while(1) {
        adcValue=ADC.read_u16(); // ponemos el valor del ADC en la variable tipo uint16_t
        voltage=adcValue*3.3 / 65535; // convertimos el valor de ADC a volts
        porcentageADC = voltage*100 / 3.3; // con el valor en volts podemos saber el porcentaje del ADC
    
        probe.convertTemperature(false, DS1820::all_devices);         //Start temperature conversion, wait until ready
        // probe.temperature() ---> temperatura en Cº
        temperatura=probe.temperature();
        porcentajetemperatura=(((float)temperatura-20)*2)/100;
        //0.013*(float)temperatura+0.09
        /* llamo a mis funciones */
        pulsadorsito1();
        pulsadorsito2();
        sensorsito();
        pulsos();
    }
}
/* funcion principal------------------------------------------------------------ */
void sensorsito()
{
    // arranco el cooler 
    if(arranque==0)
    {
        velocidad=0.33;
        arranque=1;
        printf("Arranque \r\n");
    }    
    
    switch(sensor) {
       case abierto:
            if(salida1==0 ) {
                /* en el caso que quiera controlar el cooler con el potenciometro */
                velocidad=(100-porcentageADC)/100;// el PWM cambia proporcionalmente a la variacion del ADC
                printf("PWM : %.2f \r\n",porcentageADC);
                /* cada segundo leo la cantidad de vueltas */
                vueltas=hall/4;
                printf("La velocidad es de: %d rpm \r\n",vueltas*60);
                vueltas=0;
                hall=0;
            } 
            else
               sensor=minimo; 
            break;
        /* lo siguiente se ejecutara si quiero que el cooler lo controle el sensor de temperatura */
        
        case minimo:
            if(salida1==1) {
                if(temperatura<0)
                    sensor=error;
                else if(temperatura<=20) {g=1.0;
                    velocidad=1.0;// PWM ---> 0%
                    printf("PWM : 0 \r\n");
                    printf("temperatura = %d \r\n",temperatura);
                } else if(temperatura>20)
                    sensor=lineal;  
            } else
                sensor=abierto;
            break;

        case lineal:
            if(salida1==1) {
                if(temperatura>20 && temperatura<=70) {
                    velocidad=1-porcentajetemperatura;// el PWM varia proporcionalmente a ala variacion de temperatura
                    printf("PWM : %.3f  , temperatura = %d \r\n",porcentajetemperatura,temperatura);
                } else if(temperatura>70)
                    sensor=maximo;
                else if(temperatura<20)
                    sensor=minimo;      
            } else
                sensor=abierto;
            break;

        case maximo:
            if(salida1==1) {
                if(temperatura>70) {
                    velocidad=0.0;// PWM ---> 100%
                    printf("PWM : 100 \r\n");
                } else if(temperatura<=70)
                    sensor=lineal; 
            } else
                sensor=abierto;
            break;
            
        case error:
        if(salida1==1)
        {
        printf("Error \r\n");
        if(temperatura>=0)
            sensor=minimo;
        }
        else
            sensor=abierto;
        break;
            

    }
}
/* cada vez que el efecto hall se activa cuento  */

void pulsos()
{
    if(salida2==1)
        hall++;
}

//-----------funcion pulsador que invierte-------------------------------------------------------------------------
void pulsadorsito1()
{

    switch(PIN1) {
        default:
        case 0:
            if(pin1==1) {
                cuenta1=0;
            } else if(pin1==0) {
                PIN1=1;
                cuenta1=10;
            }
            break;

        case 1:
            if(cuenta1==0 && pin1==1) {
                salida1=!salida1;
                PIN1=0;
                printf("Toque \r\n ");
            } else if( pin1==1 && cuenta1>0) {
                PIN1=0;
            }
            break;
    }

}

void contador1()
{
    if(cuenta1)
        cuenta1--;
}

//--------------funcion de pulsador por pulsos-----------------------------------------------------------------

void pulsadorsito2()
{
    switch(PIN2) {
        default:
        case 0:
            if(pin2==1) {
                salida2=0;
                cuenta2=0;
            } else if(pin2==0) {
                PIN2=1;
                cuenta2=10;
            }
            break;

        case 1:
            if(cuenta2==0 && pin2==0)
                salida2=1;
            else if(cuenta2==0 && pin2==1)
                PIN2=0;
            else if( pin2==1 && cuenta2>0)
                PIN2=0;
            break;
    }
}

void contador2()
{
    if(cuenta2)
        cuenta2--;
}
