#include "mbed.h"
#include "Rtc_Ds1307.h"
#include "TextLCD.h"
#include "QEI.h"

//Configuración de la pantalla
TextLCD lcd(PTE20,PTE21,PTE22,PTE23,PTE29,PTE30, TextLCD::LCD16x2); //Rs, E, d4, d5, d6, d7

//Configuración del reloj
Rtc_Ds1307 rtc(PTE0, PTE1); // SDA, SCL

//Configuración del puerto
Serial pc(USBTX, USBRX, "pc");

//Configuración del encoder
QEI encoder(PTD5, PTD0, NC,624);

DigitalIn alarma(PTC12);
DigitalIn snooze(PTC13); 
DigitalIn alarmaE(PTC16);
PwmOut speaker(PTA13);


char buffer[128];
int readptr = 0;
int hora=0;
int hora2=0;
int minutos=0;
int minutos2=0;
int seg=0;
int seg2=0;
int mes=0; 
int mes2=0;
int fecha=0; 
int fecha2=0;
int anno=0;
int anno2=0;
int pulsador;
int pulsador2;
int a=0;
int b=0;
int pulsos=0;
int diferencia=0;
int alarma2=0;


int main()
{
    char c;
    Rtc_Ds1307::Time_rtc tm = {};

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Configurando");
    lcd.locate(0,1);
    lcd.printf("el reloj");

    pc.printf("*************************************\n");
    pc.printf("*       Configurar el reloj         *\n");
    pc.printf("*************************************\n");

    while(1) {


        pc.printf("Ingrese la fecha (entre 1 y 31)");
        pc.scanf("%d", &tm.date);
        pc.printf("Ingrese el mes (entre 1 y 12)");
        pc.scanf("%d", &tm.mon);
        pc.printf("Ingrese el anno (ejemplo: 2016)");
        pc.scanf("%d", &tm.year);
        pc.printf("Ingrese la hora (entre 0 y 23)");
        pc.scanf("%d", &tm.hour);
        pc.printf("Ingrese los minutos (entre 0 y 59)");
        pc.scanf("%d", &tm.min);
        pc.printf("Ingrese los segundos (entre 0 y 59)");
        pc.scanf("%d", &tm.sec);
        pc.printf("Ingrese el dia (siendo Domingo=1)");
        pc.scanf("%d", &tm.wday);
        pc.printf("*************************************\n");
        pc.printf("Configurando el reloj\n");
       
        
        while(pc.readable()) {
            pc.getc();
            rtc.setTime(tm, false, false);}

        wait_ms(200);

        pc.printf("Inicializando el reloj\n");
        rtc.startClock();
  
        wait_ms(200);

        pc.printf("Leyendo el reloj\n");

loop1:     if (rtc.getTime(tm) ) {
           pulsador=alarma.read();
           
           a=(abs(tm.hour-hora))+(abs(tm.min-minutos))+(abs(tm.sec-seg))+(abs(tm.mon-mes))+(abs(tm.date-fecha))+(abs(tm.year-anno)); // Compara la hora y la fecha actual con la fecha y hora de la alarma
           b=(abs(tm.hour-hora2))+(abs(tm.min-minutos2))+(abs(tm.sec-seg2))+(abs(tm.mon-mes2))+(abs(tm.date-fecha2))+(abs(tm.year-anno2)); // Compara la hora y la fecha actual con la fecha y hora de la alarma
           
           //pc.printf("%d\n",a);
           
           if (a*b==0)
           {
loop3:      lcd.cls();
            lcd.printf("ALARMA");
            pc.printf("*************************************\n");
            pc.printf("*               ALARMA              *\n");
            pc.printf("*************************************\n");
            speaker.period(1.0/500.0);
            speaker=0.5;
            
loop4:      pulsador2=snooze.read(); // Estado del pulsador para detener o posponer la alarma
            
            if (pulsador2==0){            
            speaker=0.0;
            pc.printf("Pulsar 5 segundos para detener\n");
            lcd.cls();
            lcd.printf("Mantenga pulsado");
            lcd.locate(0,1);
            lcd.printf("para detener");
            wait(5); 
            pulsador2=snooze.read();
            if (pulsador2==0){ // Si despues de 5 segundos el pulsador todavia está oprimido, se detiene la alarma
                lcd.cls();
                lcd.printf("Alarma");
                lcd.locate(0,1);
                lcd.printf("desactivada");
                pc.printf("*************************************\n");
                pc.printf("*           Alarma desactivada      *\n");
                pc.printf("*************************************\n");
                wait(2);
                goto loop1;   
                }else{ // Si el pulsador ya no está oprimido, se pospone la alarma un minuto
                lcd.cls();
                lcd.printf("Snooze");
                pc.printf("*************************************\n");
                pc.printf("*           Snooze                  *\n");
                pc.printf("*************************************\n");
                wait(60);
                goto loop3;     
                   } 
                        
             }else {
               goto loop4;  }
             }
             
            //pc.printf("La hora actual es: %02d:%02d:%02d\n", tm.hour, tm.min, tm.sec);
            //pc.printf("La fecha actual es : %s, %02d/%02d/%04d\n", rtc.weekdayToString(tm.wday), tm.mon, tm.date, tm.year);

           else if (pulsador==0) {
                lcd.cls();
                lcd.printf("Ver/Configurar");
                lcd.locate(0,1);
                lcd.printf("alarma");
                pc.printf("*************************************\n");
                pc.printf("* alarma  - configurar alarma       *\n");
                pc.printf("* ver     - ver alarma              *\n");
                pc.printf("*************************************\n");

loop2:          readptr = 0;
               
               //Obtengo la cadena de caracteres correspondiente a la orden
               
                while( (c = pc.getc()) != '\n') {
                buffer[readptr++] = c; }
                buffer[readptr++] = 0;

               // Configurar alarma desde el computador  
                if (strncmp(buffer, "alarma", 6) == 0) {
                    
                    lcd.cls();
                    lcd.printf("Configurando");
                    lcd.locate(0,1);
                    lcd.printf("alarma");
                    pc.printf("*************************************\n");
                    pc.printf("*             Nueva alarma          *\n");
                    pc.printf("Fecha de la alarma  (0..31)");
                    pc.scanf("%d", &fecha);
                    pc.printf("Mes de la alarma (1..12)");
                    pc.scanf("%d", &mes);
                    pc.printf("Anno de la alarma");
                    pc.scanf("%d", &anno);
                    pc.printf("Hora de la alarma (0..23)");
                    pc.scanf("%d", &hora);
                    pc.printf("Minutos de la alarma (0..59)");
                    pc.scanf("%d",&minutos);
                    pc.printf("Segundos de la alarma (0..59)");
                    pc.scanf("%d", &seg);
                    pc.printf("*      Fin de la configuracion      *\n");
                    pc.printf("*************************************\n");
                    lcd.cls();
                    lcd.printf("Fin de la configuracion");
                    wait_ms(500);
                    goto loop1;
                    
                } else if (strncmp(buffer, "ver", 3) == 0) {
                    
                    if(anno==0){
                    pc.printf("No hay alarma 1\n");
                    lcd.cls();
                    lcd.printf("No hay alarma 1");
                    wait_ms(500);    
                     }else{
                    pc.printf("Hora de la alarma : %02d:%02d:%02d\n", hora, minutos, seg);
                    pc.printf("Fecha de la alarma : %02d/%02d/%04d\n", fecha, mes, anno);
                    lcd.cls();
                    lcd.printf("Alarma 1");
                    wait (1);
                    lcd.printf("%02d:%02d:%02d", hora, minutos, seg);
                    lcd.locate(0,1);
                    lcd.printf("%02d:%02d:%02d", fecha, mes, anno);
                    wait(2);}
                    
                    if(alarma2==0){
                    pc.printf("No hay alarma 2\n");
                    lcd.locate(0,1);
                    lcd.printf("No hay alarma 2");
                    wait_ms(500);    
                     }else{
                    pc.printf("Hora de la alarma 2 : %02d:%02d:%02d\n", hora2, minutos2, seg2);
                    pc.printf("Fecha de la alarma 2: %02d/%02d/%04d\n", fecha2, mes2, anno2);
                    lcd.cls();
                    lcd.printf("Alarma 2");
                    wait (1);
                    lcd.printf("%02d:%02d:%02d", hora2, minutos2, seg2);
                    lcd.locate(0,1);
                    lcd.printf("%02d:%02d:%02d", fecha2, mes2, anno2);
                    wait(2);}
                    
                                       
                    goto loop1;
                    
                } else {
                    goto loop2;
                }


            } 
            
            // Configura alarma con encoder
            else if (alarmaE==0){
            pc.printf("*    Configurar alarma con encoder     *\n");
            lcd.cls();
            lcd.printf("Alarma con");
            lcd.locate(0,1);
            lcd.printf("encoder");
            wait (1);
 
 
 //Configuración fecha             
            
            pc.printf("Fecha de la alarma:\n");
            lcd.cls();
            lcd.printf("Fecha");
            
loop5:      diferencia=encoder.getPulses()-pulsos;
            pulsos=encoder.getPulses();
            if (!alarmaE){
            pc.printf("\n");     
            pc.printf("Mes de la alarma:\n"); 
            lcd.cls();
            lcd.printf("Mes");
            diferencia=0;
            pulsos=0; 
            wait(1);
            goto loop6;  
                }else{
            if (diferencia==0){
             wait(0.1);
            goto loop5;                    
                }else if (diferencia+fecha2>=31){
                fecha2=31;
                  pc.printf("%02d\n", fecha2);
                  lcd.locate(0,1);
                  lcd.printf("%02d",fecha2);
                  wait(0.1);
                  goto loop5;
                  }else if(diferencia+fecha2<1)   {
                    fecha2=1;
                  pc.printf("%02d\n", fecha2);
                  lcd.locate(0,1);
                  lcd.printf("%02d",fecha2);
                  wait(0.1);
                  goto loop5;
                    }else{
                   fecha2+=diferencia;
                   pc.printf("%02d\n", fecha2);
                   lcd.locate(0,1);
                   lcd.printf("%02d",fecha2);
                   wait(0.1);
                   goto loop5; 
            }}
 
 
 
 //Configuración mes    
 
 
 loop6:     diferencia=encoder.getPulses()-pulsos;
            pulsos=encoder.getPulses();
            if (!alarmaE){
            pc.printf("\n");     
            pc.printf("Anno de la alarma:\n"); 
            lcd.cls();
            lcd.printf("Anno");
            diferencia=0;
            pulsos=0; 
            wait(1);
            goto loop7;  
                }else{
            if (diferencia==0){
             wait(0.1);
            goto loop6;                    
                }else if (diferencia+mes2>=12){
                mes2=12;
                  pc.printf("%02d\n", mes2);
                  lcd.locate(0,1);
                  lcd.printf("%02d",mes2);
                  wait(0.1);
                  goto loop6;
                  }else if(diferencia+mes2<1)   {
                    mes2=1;
                  pc.printf("%02d\n", mes2);
                  lcd.locate(0,1);
                  lcd.printf("%02d",mes2);
                  wait(0.1);
                  goto loop6;
                    }else{
                   mes2+=diferencia;
                   pc.printf("%02d\n", mes2);
                   lcd.locate(0,1);
                   lcd.printf("%02d",mes2);
                   wait(0.1);
                   goto loop6 ; 
            }}
 
 
 
 //Configuración año
 loop7:     diferencia=encoder.getPulses()-pulsos;
            pulsos=encoder.getPulses();
            if (!alarmaE){
            pc.printf("\n");     
            pc.printf("Hora de la alarma:\n"); 
            lcd.cls();
            lcd.printf("Hora");
            diferencia=0;
            pulsos=0; 
            wait(1);
            goto loop8;  
                }else{
            if (diferencia==0){
             wait(0.1);
            goto loop7;                    
                }else if (diferencia+anno2>=2255){
                anno2=2255;
                  pc.printf("%04d\n", anno2);
                  lcd.locate(0,1);
                  lcd.printf("%04d", anno2);
                  wait(0.1);
                  goto loop7;
                  }else if(diferencia+anno2<2000)   {
                    anno2=2000;
                  pc.printf("%04d\n", anno2);
                  lcd.locate(0,1);
                  lcd.printf("%04d",anno2);
                  wait(0.1);
                  goto loop7;
                    }else{
                   anno2+=diferencia;
                   pc.printf("%04d\n", anno2);
                   lcd.locate(0,1);
                   lcd.printf("%04d",anno2);
                   wait(0.1);
                   goto loop7 ; 
            }}
 
 
 //Configuración hora
 
 
 loop8:     diferencia=encoder.getPulses()-pulsos;
            pulsos=encoder.getPulses();
            if (!alarmaE){
            pc.printf("\n");     
            pc.printf("Minutos de la alarma:\n"); 
            lcd.cls();
            lcd.printf("Minutos");
            diferencia=0;
            pulsos=0; 
            wait(1);
            goto loop9;  
                }else{
            if (diferencia==0){
             wait(0.1);
            goto loop8;                    
                }else if (diferencia+hora2>=23){
                hora2=23;
                  pc.printf("%02d\n", hora2);
                  lcd.locate(0,1);
                  lcd.printf("%02d", hora2);
                  wait(0.1);
                  goto loop8;
                  }else if(diferencia+hora2<0)   {
                    hora2=0;
                  pc.printf("%02d\n", hora2);
                  lcd.locate(0,1);
                  lcd.printf("%02d",hora2);
                  wait(0.1);
                  goto loop8;
                    }else{
                   hora2+=diferencia;
                   pc.printf("%02d\n", hora2);
                   lcd.locate(0,1);
                   lcd.printf("%02d",hora2);
                   wait(0.1);
                   goto loop8 ; 
            }}
 
 //Configuración minutos     
loop9:      diferencia=encoder.getPulses()-pulsos;
            pulsos=encoder.getPulses();
            if (!alarmaE){
            pc.printf("\n");     
            pc.printf("Segundos de la alarma:\n"); 
            lcd.cls();
            lcd.printf("Segundos");
            diferencia=0;
            pulsos=0; 
            wait(1);
            goto loop10;  
                }else{
            if (diferencia==0){
             wait(0.1);
            goto loop9;                    
                }else if (diferencia+minutos2>=59){
                minutos2=59;
                  pc.printf("%02d\n", minutos2);
                  lcd.locate(0,1);
                  lcd.printf("%02d", minutos2);
                  wait(0.1);
                  goto loop9;
                  }else if(diferencia+minutos2<0)   {
                    minutos2=0;
                  pc.printf("%02d\n", minutos2);
                  lcd.locate(0,1);
                  lcd.printf("%02d",minutos2);
                  wait(0.1);
                  goto loop9;
                    }else{
                   minutos2+=diferencia;
                   pc.printf("%02d\n", minutos2);
                   lcd.locate(0,1);
                   lcd.printf("%02d",minutos2);
                   wait(0.1);
                   goto loop9 ; 
            }}

//Configuración segundos

loop10:      diferencia=encoder.getPulses()-pulsos;
            pulsos=encoder.getPulses();
            if (!alarmaE){
            pc.printf("\n");     
            pc.printf("*    Fin de la configuracion    *\n"); 
            lcd.cls();
            lcd.printf("Fin de la configuracion");
            diferencia=0;
            pulsos=0; 
            alarma2=1;
            wait(1);
            goto loop1;  
                }else{
            if (diferencia==0){
             wait(0.1);
            goto loop10;                    
                }else if (diferencia+seg2>=59){
                seg2=59;
                  pc.printf("%02d\n", seg2);
                  lcd.locate(0,1);
                  lcd.printf("%02d", seg2);
                  wait(0.1);
                  goto loop10;
                  }else if(diferencia+seg2<0)   {
                    seg2=0;
                  pc.printf("%02d\n", seg2);
                  lcd.locate(0,1);
                  lcd.printf("%02d",seg2);
                  wait(0.1);
                  goto loop10;
                    }else{
                   seg2+=diferencia;
                   pc.printf("%02d\n", seg2);
                   lcd.locate(0,1);
                   lcd.printf("%02d",seg2);
                   wait(0.1);
                   goto loop10 ; 
            }}

           
            }else {
                //Actualizo la hora y la fecha
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("%02d:%02d:%02d", tm.hour, tm.min, tm.sec);
                lcd.locate(0,1);
                lcd.printf("%s/%02d/%02d/%4d", rtc.weekdayToString(tm.wday), tm.date, tm.mon, tm.year);
                wait_ms(200);
                goto loop1;
            }//else
        }



    }// while (1)
}// main 
