#include "player.h"
#include"SDFileSystem.h"

SDFileSystem sd(D11, D12, D13, D9, "sd"); // the pinout on the mbed Cool
vs10xx vs1053(D11, D12, D13, D6, D7, D2, D8);//mosi,miso,sclk,xcs,xdcs,dreq,xreset
Serial aa(USBTX, USBRX);
Serial pc(D1, D0);
Serial lcd(PA_11,PA_12);
Serial bt(PA_15,PB_7);
playerStatetype  playerState;
static unsigned char fileBuf[48000];
unsigned char *bufptr;
char green;
bool startplaysong;
bool playsong;
char datainput;

char list[20][50];            //song list

char data ;

char button,press,test_pop;
uint8_t test,test_get;
int state,size,count_ok,mode_name,mode_button,count_press,page,game_mode,set_mode_loop;
char alphabet [26]  = {'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'};
char user_name[10];


void Player::begin(void)
{
    DirHandle *dir;
    struct dirent *ptr;
		FileHandle *fp;
   
    vs1053.reset();
    dir = opendir("/sd");
    //printf("\r\n**********playing list**********\r\n");
    unsigned char i = 0,j=0;
    while(((ptr = dir->readdir()) != NULL)&&(i <20))
    {
        if(strstr(ptr->d_name,".mp3")||strstr(ptr->d_name,".MP3"))
        {
							fp =sd.open(ptr->d_name, O_RDONLY);
							if(fp != NULL) 
							{
								char *byte = ptr->d_name;
                				j=0;
                				while(*byte){
                    				list[i][j++]  = *byte++;
                    				green=i;
                }
                aa.printf("%2d . %s\r\n", i,list[i++]);
				//fp->close();
							}
        }
    }
		dir->closedir();
}





/*  select file by num.  */
void Player::selectfile(char n){

    startplaysong=false;
    playerState =PS_STOP;
    playsong=false;
    green = n;
    }
    
    
    
/*  This function stop an audio file.  */
void Player::stop(void){
    startplaysong=true;
    playerState =PS_STOP;
    }
    
//--------------------------------------------------------------------//
    
void Player::SGMP_First_Page(void){
    pc.printf("SGMP\nPress Enter to start\n");
    lcd.printf("p001f");
    selectfile(3);
    playFile(list[green]);
    while(1){
        
        if(bt.readable()) {
            button = bt.getc();
            if (button == 'E'){
                button = NULL;
                break;
            }
        }
    }
}

void Player::set_name(void) {
    lcd.puts("p002f");
    wait_ms(500);
    lcd.printf("%c",char(alphabet[state]));
    state = 0;
    size = 0;
    count_ok = 0;
    mode_name = 1;
    
    while(mode_name){
        if(bt.readable()) {
            button = bt.getc();
//            pc.printf("button = %c \n",button);
//            }}}
            switch(button){
                case 'U':                      //UP Button
                    if(state == 0){
                        state = 25;
                    }
                    else{
                        state--; 
                    }
                    lcd.printf("%c",char(alphabet[state]));
                    pc.printf("alphabet = %c     ",alphabet[state]);
                    pc.printf("    name = %s     \n",user_name);
//                    pc.printf("    size = %d     ",size);
//                    pc.printf("    state = %d \n",state);
                    wait_ms(600);
                    count_ok = 0;
                    break;
                case 'D':                     //DOWN Button
                    if(state == 25){
                        state = 0;
                    }
                    else{
                        state++; 
                    }
                    lcd.printf("%c",char(alphabet[state]));
                    pc.printf("alphabet = %c     ",alphabet[state]);
                    pc.printf("    name = %s     \n",user_name);
//                    pc.printf("    size = %d     ",size);
//                    pc.printf("    state = %d \n",state);
//                    pc.printf("DOWN\n");
                    wait_ms(600);
                    count_ok = 0;
                    break;
                case 'O':                     //OK Button
                    user_name[size++] = alphabet[state];
                    lcd.printf("k%sf",user_name);
                    pc.printf("alphabet = %c     ",alphabet[state]);
                    pc.printf("    name = %s     \n",user_name);
//                    pc.printf("    size = %d     ",size);
//                    pc.printf("    state = %d \n",state);
                    
//                    pc.printf("%c\n",button);
                    
                    wait_ms(600);
                    
                    break;
                case 'C':                     //OK Button
                    if(size > 0){
                        size--;
                        user_name[size] = NULL;
                    }
                    lcd.printf("k%sf",user_name);
                    pc.printf("alphabet = %c     ",alphabet[state]);
                    pc.printf("    name = %s     \n",user_name);
//                    pc.printf("    size = %d     ",size);
//                    pc.printf("    state = %d \n",state);
                    
//                    pc.printf("%c\n",button);
                    
                    wait_ms(600);
                    
                    break;
                case 'E':                     //Enter Button
                    page = 3;
                    lcd.printf("x");
                    mode_name = 0;
                    
//                    pc.printf("ENTER\n");
//                    wait_ms(600);
                    break;
                    
            }
        }

    }
    button = NULL;
    wait_ms(600);
//    lcd.printf("Name = %s",user_name);
//    pc.printf("alphabet = %c     ",alphabet[state]);
    pc.printf("    name = %s     \n",user_name);
//    pc.printf("    size = %d     ",size);
//    pc.printf("    state = %d \n",state);
//    return user_name;
	pc.printf("finish your name is : %s \n",user_name);
}

void Player::set_mode(void){
    lcd.puts("p003f");
    button = NULL;
    wait_ms(600);
    set_mode_loop = 1;
//    lcd.printf("%d",game_mode);
    while(set_mode_loop){
        if(bt.readable()) {
            button = bt.getc();
            switch(button){
                case 'U':
                    if(game_mode == 1){
                        game_mode = 3;
                    }
                    else{
                        game_mode--;
                    }
                    wait_ms(600);
                    lcd.printf("%d",game_mode);
                    pc.printf("set_mode = %d \n",game_mode);
                    break;
                case 'D':
                    if(game_mode == 3){
                        game_mode = 1;
                    }
                    else{
                        game_mode++;
                    }
                    wait_ms(600);
                    lcd.printf("%d",game_mode);
                    pc.printf("set_mode = %d \n",game_mode);
                    break;
                case 'E':
                    set_mode_loop = 0;
                    break;
            }
        }
    }
    pc.printf("finish set_mode = %d \n",game_mode);
}
    
//--------------------------------------------------------------------//
    
void Player::run(void){	
			if(datainput=='0'){
				selectfile(0);
				playFile(list[green]);
    	
				}
			if(datainput=='1'){
				selectfile(1);
				playFile(list[green]);
				
				
				}
			if(datainput=='2'){
				selectfile(2);
				playFile(list[green]);
    		
				}
			if(datainput=='3'){
				selectfile(3);
				playFile(list[green]);
    			
				}
			if(datainput=='4'){
				selectfile(4);
				playFile(list[green]);

				}
			if(datainput=='5'){
				selectfile(5);
				playFile(list[green]);

				}
			else{
				stop();
				}
}



//void Player::read(void){
//	bt.readable();
//	datainput = bt.getc();
//
//    }

    
    
/*  This function plays audio file.  */
void Player::playFile(char *file) {
    int bytes;        // How many bytes in buffer left
    char n;
    
    playerState = PS_PLAY;
    
    vs1053.setFreq(24000000);     //hight speed
    
    FileHandle *fp =sd.open(file, O_RDONLY);
    
    if(fp == NULL) {
        printf("Could not open %s\r\n",file);

    }
    else
    {
        printf("Playing %s ...\r\n",file);
        
        /* Main playback loop */
        while((bytes = fp->read(fileBuf,48000)) > 0) {	
       {
            if(bt.readable()){
            	break;
    			}
    		vs1053.setFreq(24000000); 
            bufptr = fileBuf;
            // actual audio data gets sent to VS10xx.
            while(bytes > 0)
            {
                n = (bytes < 32)?bytes:32; //defalt 32 
                vs1053.writeData(bufptr,n);
                bytes -= n;
                bufptr += n;
                if(bt.readable()){
                	break;
    			}
                
            }
            uint8_t vol = 0x00;//set vlume
            vs1053.setVolume(vol);  //set vlume
            
            if(playerState != PS_PLAY)         //stop
            {
                fp->close();
                vs1053.softReset();
            }
            	
			}
        }
    }

}

