#include "mbed.h"
#include "ESP8266Interface.h"
#include "TextLCD.h"

DigitalOut myled(LED1);
DigitalIn switchInput(PTB16);
ESP8266Interface esp(D1, D0);
I2C i2c_lcd(A4,A5); // SDA, SCL
Serial output(USBTX, USBRX);

TextLCD_I2C lcd(&i2c_lcd, 0x7E, TextLCD::LCD16x2); // I2C bus, PCF8574 Slaveaddress, LCD Type ok

int esp8266_init(void);

int main() 
{
    
    //esp8266_init();
    
    lcd.printf("Teh Kian Keong\n"); 
    while(1) 
    {
   		
           
    }
}


int esp8266_init(void)
{
	 output.baud(115200);

    output.printf("Starting\r\n");
    NetworkInterface *network_interface = 0;
    int connect_success = -1;
    output.printf("\n\rUsing WiFi \r\n");
    output.printf("\n\rConnecting to WiFi..\r\n");
    connect_success = esp.connect("YEE", "YEE1235678900");
    network_interface = &esp;
    
    if(connect_success == 0) 
    {
    	output.printf("\n\rConnected to Network successfully\r\n");
    } 
    else 
    {
    	output.printf("\n\rConnection to Network Failed %d! Exiting application....\r\n", connect_success);
    return 0;
    }
    
    const char *ip_addr = network_interface->get_ip_address();
    if (ip_addr) {
        output.printf("IP address %s\r\n", ip_addr);
    } else {
        output.printf("No IP address\r\n");
    }
	
	return 0;
}