#include "mbed.h"
#include "ble/BLE.h"

DigitalOut led(LED1, 1);
Serial pc(P0_0, P0_1);

DigitalOut dSwitch(P0_4);

PwmOut ledB(P0_5);
PwmOut ledG(P0_6);
PwmOut ledR(P0_7);

uint16_t customServiceUUID  = 0x1812;

uint16_t readCharUUID       = 0xA001;
uint16_t writeCharUUID      = 0xA002;
uint16_t writeRedCharUUID   = 0xA003;
uint16_t writeGreenCharUUID = 0xA004;


const static char     DEVICE_NAME[]        = "GATT Example"; // change this
static const uint16_t uuid16_list[]        = {0xFFFF}; //Custom UUID, FFFF is reserved for development



/* Set Up custom Characteristics -----------------------------------------------------------------------------------------------------*/
static uint8_t readValue[10] = {0};
ReadOnlyArrayGattCharacteristic<uint8_t, sizeof(readValue)> readChar(readCharUUID, readValue);

static uint8_t writeValue[10] = {0};
WriteOnlyArrayGattCharacteristic<uint8_t, sizeof(writeValue)> writeChar(writeCharUUID, writeValue);

//On construit un "WriteOnlyArrayGattCharacteristic" --> writeRedChar
static uint8_t writeRedValue[10] = {0};
WriteOnlyArrayGattCharacteristic<uint8_t, sizeof(writeRedValue)> writeRedChar(writeRedCharUUID, writeRedValue);

static uint8_t writeGreenValue[10] = {0};
WriteOnlyArrayGattCharacteristic<uint8_t, sizeof(writeGreenValue)> writeGreenChar(writeGreenCharUUID, writeGreenValue);


/* ---------------------------------------------------------------------------------------------------------------------*/


/* Set up custom service */
GattCharacteristic *characteristics[] = {&readChar, &writeChar, &writeRedChar, &writeGreenChar};
GattService        customService(customServiceUUID, characteristics, sizeof(characteristics) / sizeof(GattCharacteristic *));


/*
 *  Restart advertising when phone app disconnects
*/
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *)
{
    BLE::Instance(BLE::DEFAULT_INSTANCE).gap().startAdvertising();
}

/*
 *  Handle writes to writeCharacteristic
*/
void writeCharCallback(const GattWriteCallbackParams *params)
{
    /* Check to see what characteristic was written, by handle */
    if(params->handle == writeChar.getValueHandle()) {
        
        float fPwm =  (float) ( 100 - params->data[0] ) / 100.0;
        pc.printf("fPwm --> %f\n", fPwm);
        ledB.write(fPwm);

        /* Update the readChar with the value of writeChar */
        BLE::Instance(BLE::DEFAULT_INSTANCE).gattServer().write(readChar.getValueHandle(), params->data, params->len);
    }
    /* Check to see what characteristic was written, by handle */
    else if(params->handle == writeRedChar.getValueHandle()) {

        float fPwm =  (float) ( 100 - params->data[0] ) / 100.0;
        pc.printf("fPwm --> %f\n", fPwm);
        ledR.write(fPwm);
        
        if(fPwm >= 0.50)
            dSwitch = true;
        else
            dSwitch = false;
    }
    /* Check to see what characteristic was written, by handle */
    else if(params->handle == writeGreenChar.getValueHandle()) {

        float fPwm =  (float) ( 100 - params->data[0] ) / 100.0;
        pc.printf("fPwm --> %f\n", fPwm);
        ledG.write(fPwm);
    }
}
/*
 * Initialization callback
 */
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE &ble          = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {
        return;
    }

    ble.gap().onDisconnection(disconnectionCallback);
    ble.gattServer().onDataWritten(writeCharCallback);

    /* Setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE); // BLE only, no classic BT
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED); // advertising type
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME)); // add name
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list)); // UUID's broadcast in advertising packet
    ble.gap().setAdvertisingInterval(100); // 100ms.

    /* Add our custom service */
    ble.addService(customService);

    /* Start advertising */
    ble.gap().startAdvertising();
}

/*
 *  Main loop
*/
int main(void)
{
    /* initialize stuff */
    pc.printf("\n\r********* Starting Main Loop *********\n\r");

    ledB = 1;
    ledG = 1;
    ledR = 1;
    
    dSwitch = false;

    BLE& ble = BLE::Instance(BLE::DEFAULT_INSTANCE);
    ble.init(bleInitComplete);

    /* SpinWait for initialization to complete. This is necessary because the
     * BLE object is used in the main loop below. */
    while (ble.hasInitialized()  == false) {
        /* spin loop */
    }

    /* Infinite loop waiting for BLE interrupt events */
    while (true) {
        ble.waitForEvent(); /* Save power */
    }
}